package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeExecutePlaybooks invokes the sophonsoar.DescribeExecutePlaybooks API synchronously
func (client *Client) DescribeExecutePlaybooks(request *DescribeExecutePlaybooksRequest) (response *DescribeExecutePlaybooksResponse, err error) {
	response = CreateDescribeExecutePlaybooksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeExecutePlaybooksWithChan invokes the sophonsoar.DescribeExecutePlaybooks API asynchronously
func (client *Client) DescribeExecutePlaybooksWithChan(request *DescribeExecutePlaybooksRequest) (<-chan *DescribeExecutePlaybooksResponse, <-chan error) {
	responseChan := make(chan *DescribeExecutePlaybooksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeExecutePlaybooks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeExecutePlaybooksWithCallback invokes the sophonsoar.DescribeExecutePlaybooks API asynchronously
func (client *Client) DescribeExecutePlaybooksWithCallback(request *DescribeExecutePlaybooksRequest, callback func(response *DescribeExecutePlaybooksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeExecutePlaybooksResponse
		var err error
		defer close(result)
		response, err = client.DescribeExecutePlaybooks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeExecutePlaybooksRequest is the request struct for api DescribeExecutePlaybooks
type DescribeExecutePlaybooksRequest struct {
	*requests.RpcRequest
	PlaybookName string           `position:"Query" name:"PlaybookName"`
	ParamType    string           `position:"Query" name:"ParamType"`
	RoleFor      string           `position:"Query" name:"RoleFor"`
	InputMode    string           `position:"Query" name:"InputMode"`
	CheckTag     requests.Integer `position:"Query" name:"CheckTag"`
	Source       string           `position:"Query" name:"Source"`
	Uuid         string           `position:"Query" name:"Uuid"`
	RoleType     string           `position:"Query" name:"RoleType"`
	Lang         string           `position:"Query" name:"Lang"`
}

// DescribeExecutePlaybooksResponse is the response struct for api DescribeExecutePlaybooks
type DescribeExecutePlaybooksResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	PlaybookMetrics []Data `json:"PlaybookMetrics" xml:"PlaybookMetrics"`
}

// CreateDescribeExecutePlaybooksRequest creates a request to invoke DescribeExecutePlaybooks API
func CreateDescribeExecutePlaybooksRequest() (request *DescribeExecutePlaybooksRequest) {
	request = &DescribeExecutePlaybooksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribeExecutePlaybooks", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeExecutePlaybooksResponse creates a response to parse from DescribeExecutePlaybooks response
func CreateDescribeExecutePlaybooksResponse() (response *DescribeExecutePlaybooksResponse) {
	response = &DescribeExecutePlaybooksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
