package tag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenCreatedBy invokes the tag.OpenCreatedBy API synchronously
func (client *Client) OpenCreatedBy(request *OpenCreatedByRequest) (response *OpenCreatedByResponse, err error) {
	response = CreateOpenCreatedByResponse()
	err = client.DoAction(request, response)
	return
}

// OpenCreatedByWithChan invokes the tag.OpenCreatedBy API asynchronously
func (client *Client) OpenCreatedByWithChan(request *OpenCreatedByRequest) (<-chan *OpenCreatedByResponse, <-chan error) {
	responseChan := make(chan *OpenCreatedByResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenCreatedBy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenCreatedByWithCallback invokes the tag.OpenCreatedBy API asynchronously
func (client *Client) OpenCreatedByWithCallback(request *OpenCreatedByRequest, callback func(response *OpenCreatedByResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenCreatedByResponse
		var err error
		defer close(result)
		response, err = client.OpenCreatedBy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenCreatedByRequest is the request struct for api OpenCreatedBy
type OpenCreatedByRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      string           `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// OpenCreatedByResponse is the response struct for api OpenCreatedBy
type OpenCreatedByResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOpenCreatedByRequest creates a request to invoke OpenCreatedBy API
func CreateOpenCreatedByRequest() (request *OpenCreatedByRequest) {
	request = &OpenCreatedByRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Tag", "2018-08-28", "OpenCreatedBy", "tag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOpenCreatedByResponse creates a response to parse from OpenCreatedBy response
func CreateOpenCreatedByResponse() (response *OpenCreatedByResponse) {
	response = &OpenCreatedByResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
