package tdsr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMainScenes invokes the tdsr.ListMainScenes API synchronously
// api document: https://help.aliyun.com/api/tdsr/listmainscenes.html
func (client *Client) ListMainScenes(request *ListMainScenesRequest) (response *ListMainScenesResponse, err error) {
	response = CreateListMainScenesResponse()
	err = client.DoAction(request, response)
	return
}

// ListMainScenesWithChan invokes the tdsr.ListMainScenes API asynchronously
// api document: https://help.aliyun.com/api/tdsr/listmainscenes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListMainScenesWithChan(request *ListMainScenesRequest) (<-chan *ListMainScenesResponse, <-chan error) {
	responseChan := make(chan *ListMainScenesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMainScenes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMainScenesWithCallback invokes the tdsr.ListMainScenes API asynchronously
// api document: https://help.aliyun.com/api/tdsr/listmainscenes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListMainScenesWithCallback(request *ListMainScenesRequest, callback func(response *ListMainScenesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMainScenesResponse
		var err error
		defer close(result)
		response, err = client.ListMainScenes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMainScenesRequest is the request struct for api ListMainScenes
type ListMainScenesRequest struct {
	*requests.RpcRequest
	QueryName string `position:"Query" name:"QueryName"`
}

// ListMainScenesResponse is the response struct for api ListMainScenes
type ListMainScenesResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrMessage   string `json:"ErrMessage" xml:"ErrMessage"`
	Data         string `json:"Data" xml:"Data"`
	ObjectString string `json:"ObjectString" xml:"ObjectString"`
}

// CreateListMainScenesRequest creates a request to invoke ListMainScenes API
func CreateListMainScenesRequest() (request *ListMainScenesRequest) {
	request = &ListMainScenesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("tdsr", "2020-01-01", "ListMainScenes", "", "")
	request.Method = requests.POST
	return
}

// CreateListMainScenesResponse creates a response to parse from ListMainScenes response
func CreateListMainScenesResponse() (response *ListMainScenesResponse) {
	response = &ListMainScenesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
