package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMember invokes the ververica.DeleteMember API synchronously
func (client *Client) DeleteMember(request *DeleteMemberRequest) (response *DeleteMemberResponse, err error) {
	response = CreateDeleteMemberResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMemberWithChan invokes the ververica.DeleteMember API asynchronously
func (client *Client) DeleteMemberWithChan(request *DeleteMemberRequest) (<-chan *DeleteMemberResponse, <-chan error) {
	responseChan := make(chan *DeleteMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMemberWithCallback invokes the ververica.DeleteMember API asynchronously
func (client *Client) DeleteMemberWithCallback(request *DeleteMemberRequest, callback func(response *DeleteMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMemberResponse
		var err error
		defer close(result)
		response, err = client.DeleteMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMemberRequest is the request struct for api DeleteMember
type DeleteMemberRequest struct {
	*requests.RoaRequest
	Workspace string `position:"Path" name:"workspace"`
	Namespace string `position:"Path" name:"namespace"`
	Member    string `position:"Path" name:"member"`
}

// DeleteMemberResponse is the response struct for api DeleteMember
type DeleteMemberResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateDeleteMemberRequest creates a request to invoke DeleteMember API
func CreateDeleteMemberRequest() (request *DeleteMemberRequest) {
	request = &DeleteMemberRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "DeleteMember", "/pop/workspaces/[workspace]/members/v1/namespaces/[namespace]/members/[member]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteMemberResponse creates a response to parse from DeleteMember response
func CreateDeleteMemberResponse() (response *DeleteMemberResponse) {
	response = &DeleteMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
