package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDatasets invokes the viapi_regen.ListDatasets API synchronously
func (client *Client) ListDatasets(request *ListDatasetsRequest) (response *ListDatasetsResponse, err error) {
	response = CreateListDatasetsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDatasetsWithChan invokes the viapi_regen.ListDatasets API asynchronously
func (client *Client) ListDatasetsWithChan(request *ListDatasetsRequest) (<-chan *ListDatasetsResponse, <-chan error) {
	responseChan := make(chan *ListDatasetsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDatasets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDatasetsWithCallback invokes the viapi_regen.ListDatasets API asynchronously
func (client *Client) ListDatasetsWithCallback(request *ListDatasetsRequest, callback func(response *ListDatasetsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDatasetsResponse
		var err error
		defer close(result)
		response, err = client.ListDatasets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDatasetsRequest is the request struct for api ListDatasets
type ListDatasetsRequest struct {
	*requests.RpcRequest
	PageSize    requests.Integer `position:"Body" name:"PageSize"`
	CurrentPage requests.Integer `position:"Body" name:"CurrentPage"`
	WorkspaceId requests.Integer `position:"Body" name:"WorkspaceId"`
}

// ListDatasetsResponse is the response struct for api ListDatasets
type ListDatasetsResponse struct {
	*responses.BaseResponse
	Message   string             `json:"Message" xml:"Message"`
	RequestId string             `json:"RequestId" xml:"RequestId"`
	Code      string             `json:"Code" xml:"Code"`
	Data      DataInListDatasets `json:"Data" xml:"Data"`
}

// CreateListDatasetsRequest creates a request to invoke ListDatasets API
func CreateListDatasetsRequest() (request *ListDatasetsRequest) {
	request = &ListDatasetsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "ListDatasets", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDatasetsResponse creates a response to parse from ListDatasets response
func CreateListDatasetsResponse() (response *ListDatasetsResponse) {
	response = &ListDatasetsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
