package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEditingProjectMaterials invokes the vod.DeleteEditingProjectMaterials API synchronously
func (client *Client) DeleteEditingProjectMaterials(request *DeleteEditingProjectMaterialsRequest) (response *DeleteEditingProjectMaterialsResponse, err error) {
	response = CreateDeleteEditingProjectMaterialsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEditingProjectMaterialsWithChan invokes the vod.DeleteEditingProjectMaterials API asynchronously
func (client *Client) DeleteEditingProjectMaterialsWithChan(request *DeleteEditingProjectMaterialsRequest) (<-chan *DeleteEditingProjectMaterialsResponse, <-chan error) {
	responseChan := make(chan *DeleteEditingProjectMaterialsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEditingProjectMaterials(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEditingProjectMaterialsWithCallback invokes the vod.DeleteEditingProjectMaterials API asynchronously
func (client *Client) DeleteEditingProjectMaterialsWithCallback(request *DeleteEditingProjectMaterialsRequest, callback func(response *DeleteEditingProjectMaterialsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEditingProjectMaterialsResponse
		var err error
		defer close(result)
		response, err = client.DeleteEditingProjectMaterials(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEditingProjectMaterialsRequest is the request struct for api DeleteEditingProjectMaterials
type DeleteEditingProjectMaterialsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      string `position:"Query" name:"ResourceOwnerId"`
	MaterialType         string `position:"Query" name:"MaterialType"`
	ProjectId            string `position:"Query" name:"ProjectId"`
	ResourceOwnerAccount string `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string `position:"Query" name:"OwnerAccount"`
	OwnerId              string `position:"Query" name:"OwnerId"`
	MaterialIds          string `position:"Query" name:"MaterialIds"`
}

// DeleteEditingProjectMaterialsResponse is the response struct for api DeleteEditingProjectMaterials
type DeleteEditingProjectMaterialsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteEditingProjectMaterialsRequest creates a request to invoke DeleteEditingProjectMaterials API
func CreateDeleteEditingProjectMaterialsRequest() (request *DeleteEditingProjectMaterialsRequest) {
	request = &DeleteEditingProjectMaterialsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DeleteEditingProjectMaterials", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteEditingProjectMaterialsResponse creates a response to parse from DeleteEditingProjectMaterials response
func CreateDeleteEditingProjectMaterialsResponse() (response *DeleteEditingProjectMaterialsResponse) {
	response = &DeleteEditingProjectMaterialsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
