package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodDomainRealTimeByteHitRateData invokes the vod.DescribeVodDomainRealTimeByteHitRateData API synchronously
func (client *Client) DescribeVodDomainRealTimeByteHitRateData(request *DescribeVodDomainRealTimeByteHitRateDataRequest) (response *DescribeVodDomainRealTimeByteHitRateDataResponse, err error) {
	response = CreateDescribeVodDomainRealTimeByteHitRateDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodDomainRealTimeByteHitRateDataWithChan invokes the vod.DescribeVodDomainRealTimeByteHitRateData API asynchronously
func (client *Client) DescribeVodDomainRealTimeByteHitRateDataWithChan(request *DescribeVodDomainRealTimeByteHitRateDataRequest) (<-chan *DescribeVodDomainRealTimeByteHitRateDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVodDomainRealTimeByteHitRateDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodDomainRealTimeByteHitRateData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodDomainRealTimeByteHitRateDataWithCallback invokes the vod.DescribeVodDomainRealTimeByteHitRateData API asynchronously
func (client *Client) DescribeVodDomainRealTimeByteHitRateDataWithCallback(request *DescribeVodDomainRealTimeByteHitRateDataRequest, callback func(response *DescribeVodDomainRealTimeByteHitRateDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodDomainRealTimeByteHitRateDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodDomainRealTimeByteHitRateData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodDomainRealTimeByteHitRateDataRequest is the request struct for api DescribeVodDomainRealTimeByteHitRateData
type DescribeVodDomainRealTimeByteHitRateDataRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeVodDomainRealTimeByteHitRateDataResponse is the response struct for api DescribeVodDomainRealTimeByteHitRateData
type DescribeVodDomainRealTimeByteHitRateDataResponse struct {
	*responses.BaseResponse
	RequestId string                                         `json:"RequestId" xml:"RequestId"`
	Data      DataInDescribeVodDomainRealTimeByteHitRateData `json:"Data" xml:"Data"`
}

// CreateDescribeVodDomainRealTimeByteHitRateDataRequest creates a request to invoke DescribeVodDomainRealTimeByteHitRateData API
func CreateDescribeVodDomainRealTimeByteHitRateDataRequest() (request *DescribeVodDomainRealTimeByteHitRateDataRequest) {
	request = &DescribeVodDomainRealTimeByteHitRateDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodDomainRealTimeByteHitRateData", "vod", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeVodDomainRealTimeByteHitRateDataResponse creates a response to parse from DescribeVodDomainRealTimeByteHitRateData response
func CreateDescribeVodDomainRealTimeByteHitRateDataResponse() (response *DescribeVodDomainRealTimeByteHitRateDataResponse) {
	response = &DescribeVodDomainRealTimeByteHitRateDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
