package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodDomainSrcBpsData invokes the vod.DescribeVodDomainSrcBpsData API synchronously
func (client *Client) DescribeVodDomainSrcBpsData(request *DescribeVodDomainSrcBpsDataRequest) (response *DescribeVodDomainSrcBpsDataResponse, err error) {
	response = CreateDescribeVodDomainSrcBpsDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodDomainSrcBpsDataWithChan invokes the vod.DescribeVodDomainSrcBpsData API asynchronously
func (client *Client) DescribeVodDomainSrcBpsDataWithChan(request *DescribeVodDomainSrcBpsDataRequest) (<-chan *DescribeVodDomainSrcBpsDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVodDomainSrcBpsDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodDomainSrcBpsData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodDomainSrcBpsDataWithCallback invokes the vod.DescribeVodDomainSrcBpsData API asynchronously
func (client *Client) DescribeVodDomainSrcBpsDataWithCallback(request *DescribeVodDomainSrcBpsDataRequest, callback func(response *DescribeVodDomainSrcBpsDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodDomainSrcBpsDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodDomainSrcBpsData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodDomainSrcBpsDataRequest is the request struct for api DescribeVodDomainSrcBpsData
type DescribeVodDomainSrcBpsDataRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Interval   string           `position:"Query" name:"Interval"`
}

// DescribeVodDomainSrcBpsDataResponse is the response struct for api DescribeVodDomainSrcBpsData
type DescribeVodDomainSrcBpsDataResponse struct {
	*responses.BaseResponse
	EndTime               string                `json:"EndTime" xml:"EndTime"`
	StartTime             string                `json:"StartTime" xml:"StartTime"`
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	DomainName            string                `json:"DomainName" xml:"DomainName"`
	DataInterval          string                `json:"DataInterval" xml:"DataInterval"`
	SrcBpsDataPerInterval SrcBpsDataPerInterval `json:"SrcBpsDataPerInterval" xml:"SrcBpsDataPerInterval"`
}

// CreateDescribeVodDomainSrcBpsDataRequest creates a request to invoke DescribeVodDomainSrcBpsData API
func CreateDescribeVodDomainSrcBpsDataRequest() (request *DescribeVodDomainSrcBpsDataRequest) {
	request = &DescribeVodDomainSrcBpsDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodDomainSrcBpsData", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVodDomainSrcBpsDataResponse creates a response to parse from DescribeVodDomainSrcBpsData response
func CreateDescribeVodDomainSrcBpsDataResponse() (response *DescribeVodDomainSrcBpsDataResponse) {
	response = &DescribeVodDomainSrcBpsDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
