package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodMediaPlayData invokes the vod.DescribeVodMediaPlayData API synchronously
func (client *Client) DescribeVodMediaPlayData(request *DescribeVodMediaPlayDataRequest) (response *DescribeVodMediaPlayDataResponse, err error) {
	response = CreateDescribeVodMediaPlayDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodMediaPlayDataWithChan invokes the vod.DescribeVodMediaPlayData API asynchronously
func (client *Client) DescribeVodMediaPlayDataWithChan(request *DescribeVodMediaPlayDataRequest) (<-chan *DescribeVodMediaPlayDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVodMediaPlayDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodMediaPlayData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodMediaPlayDataWithCallback invokes the vod.DescribeVodMediaPlayData API asynchronously
func (client *Client) DescribeVodMediaPlayDataWithCallback(request *DescribeVodMediaPlayDataRequest, callback func(response *DescribeVodMediaPlayDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodMediaPlayDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodMediaPlayData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodMediaPlayDataRequest is the request struct for api DescribeVodMediaPlayData
type DescribeVodMediaPlayDataRequest struct {
	*requests.RpcRequest
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	PlayDate     string           `position:"Query" name:"PlayDate"`
	Os           string           `position:"Query" name:"Os"`
	MediaId      string           `position:"Query" name:"MediaId"`
	OrderName    string           `position:"Query" name:"OrderName"`
	PageNo       requests.Integer `position:"Query" name:"PageNo"`
	Region       string           `position:"Query" name:"Region"`
	TerminalType string           `position:"Query" name:"TerminalType"`
	OrderType    string           `position:"Query" name:"OrderType"`
}

// DescribeVodMediaPlayDataResponse is the response struct for api DescribeVodMediaPlayData
type DescribeVodMediaPlayDataResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	TotalCount  int64  `json:"TotalCount" xml:"TotalCount"`
	PageNo      int64  `json:"PageNo" xml:"PageNo"`
	PageSize    int64  `json:"PageSize" xml:"PageSize"`
	QoeInfoList []Data `json:"QoeInfoList" xml:"QoeInfoList"`
}

// CreateDescribeVodMediaPlayDataRequest creates a request to invoke DescribeVodMediaPlayData API
func CreateDescribeVodMediaPlayDataRequest() (request *DescribeVodMediaPlayDataRequest) {
	request = &DescribeVodMediaPlayDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodMediaPlayData", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVodMediaPlayDataResponse creates a response to parse from DescribeVodMediaPlayData response
func CreateDescribeVodMediaPlayDataResponse() (response *DescribeVodMediaPlayDataResponse) {
	response = &DescribeVodMediaPlayDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
