package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTranscodeSummary invokes the vod.GetTranscodeSummary API synchronously
func (client *Client) GetTranscodeSummary(request *GetTranscodeSummaryRequest) (response *GetTranscodeSummaryResponse, err error) {
	response = CreateGetTranscodeSummaryResponse()
	err = client.DoAction(request, response)
	return
}

// GetTranscodeSummaryWithChan invokes the vod.GetTranscodeSummary API asynchronously
func (client *Client) GetTranscodeSummaryWithChan(request *GetTranscodeSummaryRequest) (<-chan *GetTranscodeSummaryResponse, <-chan error) {
	responseChan := make(chan *GetTranscodeSummaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTranscodeSummary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTranscodeSummaryWithCallback invokes the vod.GetTranscodeSummary API asynchronously
func (client *Client) GetTranscodeSummaryWithCallback(request *GetTranscodeSummaryRequest, callback func(response *GetTranscodeSummaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTranscodeSummaryResponse
		var err error
		defer close(result)
		response, err = client.GetTranscodeSummary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTranscodeSummaryRequest is the request struct for api GetTranscodeSummary
type GetTranscodeSummaryRequest struct {
	*requests.RpcRequest
	VideoIds string `position:"Query" name:"VideoIds"`
}

// GetTranscodeSummaryResponse is the response struct for api GetTranscodeSummary
type GetTranscodeSummaryResponse struct {
	*responses.BaseResponse
	RequestId            string             `json:"RequestId" xml:"RequestId"`
	NonExistVideoIds     []string           `json:"NonExistVideoIds" xml:"NonExistVideoIds"`
	TranscodeSummaryList []TranscodeSummary `json:"TranscodeSummaryList" xml:"TranscodeSummaryList"`
}

// CreateGetTranscodeSummaryRequest creates a request to invoke GetTranscodeSummary API
func CreateGetTranscodeSummaryRequest() (request *GetTranscodeSummaryRequest) {
	request = &GetTranscodeSummaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "GetTranscodeSummary", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetTranscodeSummaryResponse creates a response to parse from GetTranscodeSummary response
func CreateGetTranscodeSummaryResponse() (response *GetTranscodeSummaryResponse) {
	response = &GetTranscodeSummaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
