package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVirtualPhysicalConnections invokes the vpc.ListVirtualPhysicalConnections API synchronously
func (client *Client) ListVirtualPhysicalConnections(request *ListVirtualPhysicalConnectionsRequest) (response *ListVirtualPhysicalConnectionsResponse, err error) {
	response = CreateListVirtualPhysicalConnectionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListVirtualPhysicalConnectionsWithChan invokes the vpc.ListVirtualPhysicalConnections API asynchronously
func (client *Client) ListVirtualPhysicalConnectionsWithChan(request *ListVirtualPhysicalConnectionsRequest) (<-chan *ListVirtualPhysicalConnectionsResponse, <-chan error) {
	responseChan := make(chan *ListVirtualPhysicalConnectionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVirtualPhysicalConnections(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVirtualPhysicalConnectionsWithCallback invokes the vpc.ListVirtualPhysicalConnections API asynchronously
func (client *Client) ListVirtualPhysicalConnectionsWithCallback(request *ListVirtualPhysicalConnectionsRequest, callback func(response *ListVirtualPhysicalConnectionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVirtualPhysicalConnectionsResponse
		var err error
		defer close(result)
		response, err = client.ListVirtualPhysicalConnections(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVirtualPhysicalConnectionsRequest is the request struct for api ListVirtualPhysicalConnections
type ListVirtualPhysicalConnectionsRequest struct {
	*requests.RpcRequest
	VlanIds                                 *[]string                             `position:"Query" name:"VlanIds"  type:"Repeated"`
	VirtualPhysicalConnectionBusinessStatus string                                `position:"Query" name:"VirtualPhysicalConnectionBusinessStatus"`
	ResourceGroupId                         string                                `position:"Query" name:"ResourceGroupId"`
	VirtualPhysicalConnectionAliUids        *[]string                             `position:"Query" name:"VirtualPhysicalConnectionAliUids"  type:"Repeated"`
	NextToken                               string                                `position:"Query" name:"NextToken"`
	VirtualPhysicalConnectionIds            *[]string                             `position:"Query" name:"VirtualPhysicalConnectionIds"  type:"Repeated"`
	IsConfirmed                             requests.Boolean                      `position:"Query" name:"IsConfirmed"`
	Tags                                    *[]ListVirtualPhysicalConnectionsTags `position:"Query" name:"Tags"  type:"Repeated"`
	VirtualPhysicalConnectionStatuses       *[]string                             `position:"Query" name:"VirtualPhysicalConnectionStatuses"  type:"Repeated"`
	PhysicalConnectionId                    string                                `position:"Query" name:"PhysicalConnectionId"`
	Name                                    string                                `position:"Query" name:"Name"`
	MaxResults                              requests.Integer                      `position:"Query" name:"MaxResults"`
}

// ListVirtualPhysicalConnectionsTags is a repeated param struct in ListVirtualPhysicalConnectionsRequest
type ListVirtualPhysicalConnectionsTags struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// ListVirtualPhysicalConnectionsResponse is the response struct for api ListVirtualPhysicalConnections
type ListVirtualPhysicalConnectionsResponse struct {
	*responses.BaseResponse
	RequestId                  string                      `json:"RequestId" xml:"RequestId"`
	NextToken                  string                      `json:"NextToken" xml:"NextToken"`
	TotalCount                 int                         `json:"TotalCount" xml:"TotalCount"`
	Count                      int                         `json:"Count" xml:"Count"`
	VirtualPhysicalConnections []VirtualPhysicalConnection `json:"VirtualPhysicalConnections" xml:"VirtualPhysicalConnections"`
}

// CreateListVirtualPhysicalConnectionsRequest creates a request to invoke ListVirtualPhysicalConnections API
func CreateListVirtualPhysicalConnectionsRequest() (request *ListVirtualPhysicalConnectionsRequest) {
	request = &ListVirtualPhysicalConnectionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ListVirtualPhysicalConnections", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListVirtualPhysicalConnectionsResponse creates a response to parse from ListVirtualPhysicalConnections response
func CreateListVirtualPhysicalConnectionsResponse() (response *ListVirtualPhysicalConnectionsResponse) {
	response = &ListVirtualPhysicalConnectionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
