package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVpcPublishedRouteEntries invokes the vpc.ListVpcPublishedRouteEntries API synchronously
func (client *Client) ListVpcPublishedRouteEntries(request *ListVpcPublishedRouteEntriesRequest) (response *ListVpcPublishedRouteEntriesResponse, err error) {
	response = CreateListVpcPublishedRouteEntriesResponse()
	err = client.DoAction(request, response)
	return
}

// ListVpcPublishedRouteEntriesWithChan invokes the vpc.ListVpcPublishedRouteEntries API asynchronously
func (client *Client) ListVpcPublishedRouteEntriesWithChan(request *ListVpcPublishedRouteEntriesRequest) (<-chan *ListVpcPublishedRouteEntriesResponse, <-chan error) {
	responseChan := make(chan *ListVpcPublishedRouteEntriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVpcPublishedRouteEntries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVpcPublishedRouteEntriesWithCallback invokes the vpc.ListVpcPublishedRouteEntries API asynchronously
func (client *Client) ListVpcPublishedRouteEntriesWithCallback(request *ListVpcPublishedRouteEntriesRequest, callback func(response *ListVpcPublishedRouteEntriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVpcPublishedRouteEntriesResponse
		var err error
		defer close(result)
		response, err = client.ListVpcPublishedRouteEntries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVpcPublishedRouteEntriesRequest is the request struct for api ListVpcPublishedRouteEntries
type ListVpcPublishedRouteEntriesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TargetType           string           `position:"Query" name:"TargetType"`
	NextToken            string           `position:"Query" name:"NextToken"`
	RouteTableId         string           `position:"Query" name:"RouteTableId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DestinationCidrBlock string           `position:"Query" name:"DestinationCidrBlock"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TargetInstanceId     string           `position:"Query" name:"TargetInstanceId"`
	MaxResults           requests.Integer `position:"Query" name:"MaxResults"`
}

// ListVpcPublishedRouteEntriesResponse is the response struct for api ListVpcPublishedRouteEntries
type ListVpcPublishedRouteEntriesResponse struct {
	*responses.BaseResponse
	RequestId    string                                     `json:"RequestId" xml:"RequestId"`
	NextToken    string                                     `json:"NextToken" xml:"NextToken"`
	RouteEntries []RouteEntryInListVpcPublishedRouteEntries `json:"RouteEntries" xml:"RouteEntries"`
}

// CreateListVpcPublishedRouteEntriesRequest creates a request to invoke ListVpcPublishedRouteEntries API
func CreateListVpcPublishedRouteEntriesRequest() (request *ListVpcPublishedRouteEntriesRequest) {
	request = &ListVpcPublishedRouteEntriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ListVpcPublishedRouteEntries", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListVpcPublishedRouteEntriesResponse creates a response to parse from ListVpcPublishedRouteEntries response
func CreateListVpcPublishedRouteEntriesResponse() (response *ListVpcPublishedRouteEntriesResponse) {
	response = &ListVpcPublishedRouteEntriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
