package yundun_dbaudit

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateUploadAuth invokes the yundun_dbaudit.GenerateUploadAuth API synchronously
// api document: https://help.aliyun.com/api/yundun-dbaudit/generateuploadauth.html
func (client *Client) GenerateUploadAuth(request *GenerateUploadAuthRequest) (response *GenerateUploadAuthResponse, err error) {
	response = CreateGenerateUploadAuthResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateUploadAuthWithChan invokes the yundun_dbaudit.GenerateUploadAuth API asynchronously
// api document: https://help.aliyun.com/api/yundun-dbaudit/generateuploadauth.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GenerateUploadAuthWithChan(request *GenerateUploadAuthRequest) (<-chan *GenerateUploadAuthResponse, <-chan error) {
	responseChan := make(chan *GenerateUploadAuthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateUploadAuth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateUploadAuthWithCallback invokes the yundun_dbaudit.GenerateUploadAuth API asynchronously
// api document: https://help.aliyun.com/api/yundun-dbaudit/generateuploadauth.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GenerateUploadAuthWithCallback(request *GenerateUploadAuthRequest, callback func(response *GenerateUploadAuthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateUploadAuthResponse
		var err error
		defer close(result)
		response, err = client.GenerateUploadAuth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateUploadAuthRequest is the request struct for api GenerateUploadAuth
type GenerateUploadAuthRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	Lang       string `position:"Query" name:"Lang"`
}

// GenerateUploadAuthResponse is the response struct for api GenerateUploadAuth
type GenerateUploadAuthResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	UploadConfig UploadConfig `json:"UploadConfig" xml:"UploadConfig"`
}

// CreateGenerateUploadAuthRequest creates a request to invoke GenerateUploadAuth API
func CreateGenerateUploadAuthRequest() (request *GenerateUploadAuthRequest) {
	request = &GenerateUploadAuthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Yundun-dbaudit", "2018-10-29", "GenerateUploadAuth", "dbaudit", "openAPI")
	return
}

// CreateGenerateUploadAuthResponse creates a response to parse from GenerateUploadAuth response
func CreateGenerateUploadAuthResponse() (response *GenerateUploadAuthResponse) {
	response = &GenerateUploadAuthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
