// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Updates an existing documentation version of an API.
type UpdateDocumentationVersionInput struct {
	_ struct{} `type:"structure"`

	// [Required] The version identifier of the to-be-updated documentation version.
	//
	// DocumentationVersion is a required field
	DocumentationVersion *string `location:"uri" locationName:"doc_version" type:"string" required:"true"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []PatchOperation `locationName:"patchOperations" type:"list"`

	// [Required] The string identifier of the associated RestApi..
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDocumentationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDocumentationVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDocumentationVersionInput"}

	if s.DocumentationVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("DocumentationVersion"))
	}

	if s.RestApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RestApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDocumentationVersionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.PatchOperations != nil {
		v := s.PatchOperations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "patchOperations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.DocumentationVersion != nil {
		v := *s.DocumentationVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "doc_version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RestApiId != nil {
		v := *s.RestApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "restapi_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A snapshot of the documentation of an API.
//
// Publishing API documentation involves creating a documentation version associated
// with an API stage and exporting the versioned documentation to an external
// (e.g., OpenAPI) file.
//
// Documenting an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html),
// DocumentationPart, DocumentationVersions
type UpdateDocumentationVersionOutput struct {
	_ struct{} `type:"structure"`

	// The date when the API documentation snapshot is created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// The description of the API documentation snapshot.
	Description *string `locationName:"description" type:"string"`

	// The version identifier of the API documentation snapshot.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s UpdateDocumentationVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDocumentationVersionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opUpdateDocumentationVersion = "UpdateDocumentationVersion"

// UpdateDocumentationVersionRequest returns a request value for making API operation for
// Amazon API Gateway.
//
//    // Example sending a request using UpdateDocumentationVersionRequest.
//    req := client.UpdateDocumentationVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) UpdateDocumentationVersionRequest(input *UpdateDocumentationVersionInput) UpdateDocumentationVersionRequest {
	op := &aws.Operation{
		Name:       opUpdateDocumentationVersion,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/documentation/versions/{doc_version}",
	}

	if input == nil {
		input = &UpdateDocumentationVersionInput{}
	}

	req := c.newRequest(op, input, &UpdateDocumentationVersionOutput{})
	return UpdateDocumentationVersionRequest{Request: req, Input: input, Copy: c.UpdateDocumentationVersionRequest}
}

// UpdateDocumentationVersionRequest is the request type for the
// UpdateDocumentationVersion API operation.
type UpdateDocumentationVersionRequest struct {
	*aws.Request
	Input *UpdateDocumentationVersionInput
	Copy  func(*UpdateDocumentationVersionInput) UpdateDocumentationVersionRequest
}

// Send marshals and sends the UpdateDocumentationVersion API request.
func (r UpdateDocumentationVersionRequest) Send(ctx context.Context) (*UpdateDocumentationVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDocumentationVersionResponse{
		UpdateDocumentationVersionOutput: r.Request.Data.(*UpdateDocumentationVersionOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDocumentationVersionResponse is the response type for the
// UpdateDocumentationVersion API operation.
type UpdateDocumentationVersionResponse struct {
	*UpdateDocumentationVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDocumentationVersion request.
func (r *UpdateDocumentationVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
