// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribePoliciesInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The maximum number of items to be returned with each call. The default value
	// is 50 and the maximum value is 100.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The names of one or more policies. If you omit this parameter, all policies
	// are described. If a group name is provided, the results are limited to that
	// group. This list is limited to 50 items. If you specify an unknown policy
	// name, it is ignored with no error.
	PolicyNames []string `type:"list"`

	// One or more policy types. The valid values are SimpleScaling, StepScaling,
	// and TargetTrackingScaling.
	PolicyTypes []string `type:"list"`
}

// String returns the string representation
func (s DescribePoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePoliciesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribePoliciesInput"}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribePoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that the response contains more items than can be
	// returned in a single response. To receive additional items, specify this
	// string for the NextToken value when requesting the next set of items. This
	// value is null when there are no more items to return.
	NextToken *string `type:"string"`

	// The scaling policies.
	ScalingPolicies []ScalingPolicy `type:"list"`
}

// String returns the string representation
func (s DescribePoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribePolicies = "DescribePolicies"

// DescribePoliciesRequest returns a request value for making API operation for
// Auto Scaling.
//
// Describes the policies for the specified Auto Scaling group.
//
//    // Example sending a request using DescribePoliciesRequest.
//    req := client.DescribePoliciesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribePolicies
func (c *Client) DescribePoliciesRequest(input *DescribePoliciesInput) DescribePoliciesRequest {
	op := &aws.Operation{
		Name:       opDescribePolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePoliciesInput{}
	}

	req := c.newRequest(op, input, &DescribePoliciesOutput{})
	return DescribePoliciesRequest{Request: req, Input: input, Copy: c.DescribePoliciesRequest}
}

// DescribePoliciesRequest is the request type for the
// DescribePolicies API operation.
type DescribePoliciesRequest struct {
	*aws.Request
	Input *DescribePoliciesInput
	Copy  func(*DescribePoliciesInput) DescribePoliciesRequest
}

// Send marshals and sends the DescribePolicies API request.
func (r DescribePoliciesRequest) Send(ctx context.Context) (*DescribePoliciesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribePoliciesResponse{
		DescribePoliciesOutput: r.Request.Data.(*DescribePoliciesOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribePoliciesRequestPaginator returns a paginator for DescribePolicies.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribePoliciesRequest(input)
//   p := autoscaling.NewDescribePoliciesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribePoliciesPaginator(req DescribePoliciesRequest) DescribePoliciesPaginator {
	return DescribePoliciesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribePoliciesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribePoliciesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribePoliciesPaginator struct {
	aws.Pager
}

func (p *DescribePoliciesPaginator) CurrentPage() *DescribePoliciesOutput {
	return p.Pager.CurrentPage().(*DescribePoliciesOutput)
}

// DescribePoliciesResponse is the response type for the
// DescribePolicies API operation.
type DescribePoliciesResponse struct {
	*DescribePoliciesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribePolicies request.
func (r *DescribePoliciesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
