// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListBackupPlanTemplatesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return maxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBackupPlanTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBackupPlanTemplatesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListBackupPlanTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBackupPlanTemplatesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListBackupPlanTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// An array of template list items containing metadata about your saved templates.
	BackupPlanTemplatesList []BackupPlanTemplatesListMember `type:"list"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return maxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListBackupPlanTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBackupPlanTemplatesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackupPlanTemplatesList != nil {
		v := s.BackupPlanTemplatesList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "BackupPlanTemplatesList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListBackupPlanTemplates = "ListBackupPlanTemplates"

// ListBackupPlanTemplatesRequest returns a request value for making API operation for
// AWS Backup.
//
// Returns metadata of your saved backup plan templates, including the template
// ID, name, and the creation and deletion dates.
//
//    // Example sending a request using ListBackupPlanTemplatesRequest.
//    req := client.ListBackupPlanTemplatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates
func (c *Client) ListBackupPlanTemplatesRequest(input *ListBackupPlanTemplatesInput) ListBackupPlanTemplatesRequest {
	op := &aws.Operation{
		Name:       opListBackupPlanTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/backup/template/plans",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBackupPlanTemplatesInput{}
	}

	req := c.newRequest(op, input, &ListBackupPlanTemplatesOutput{})
	return ListBackupPlanTemplatesRequest{Request: req, Input: input, Copy: c.ListBackupPlanTemplatesRequest}
}

// ListBackupPlanTemplatesRequest is the request type for the
// ListBackupPlanTemplates API operation.
type ListBackupPlanTemplatesRequest struct {
	*aws.Request
	Input *ListBackupPlanTemplatesInput
	Copy  func(*ListBackupPlanTemplatesInput) ListBackupPlanTemplatesRequest
}

// Send marshals and sends the ListBackupPlanTemplates API request.
func (r ListBackupPlanTemplatesRequest) Send(ctx context.Context) (*ListBackupPlanTemplatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListBackupPlanTemplatesResponse{
		ListBackupPlanTemplatesOutput: r.Request.Data.(*ListBackupPlanTemplatesOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListBackupPlanTemplatesRequestPaginator returns a paginator for ListBackupPlanTemplates.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListBackupPlanTemplatesRequest(input)
//   p := backup.NewListBackupPlanTemplatesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListBackupPlanTemplatesPaginator(req ListBackupPlanTemplatesRequest) ListBackupPlanTemplatesPaginator {
	return ListBackupPlanTemplatesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListBackupPlanTemplatesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListBackupPlanTemplatesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListBackupPlanTemplatesPaginator struct {
	aws.Pager
}

func (p *ListBackupPlanTemplatesPaginator) CurrentPage() *ListBackupPlanTemplatesOutput {
	return p.Pager.CurrentPage().(*ListBackupPlanTemplatesOutput)
}

// ListBackupPlanTemplatesResponse is the response type for the
// ListBackupPlanTemplates API operation.
type ListBackupPlanTemplatesResponse struct {
	*ListBackupPlanTemplatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListBackupPlanTemplates request.
func (r *ListBackupPlanTemplatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
