// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DetectEntitiesInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify any of the primary languages
	// supported by Amazon Comprehend. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode LanguageCode `type:"string" required:"true" enum:"true"`

	// A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8
	// encoded characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetectEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectEntitiesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetectEntitiesInput"}
	if len(s.LanguageCode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("LanguageCode"))
	}

	if s.Text == nil {
		invalidParams.Add(aws.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DetectEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// A collection of entities identified in the input text. For each entity, the
	// response provides the entity text, entity type, where the entity text begins
	// and ends, and the level of confidence that Amazon Comprehend has in the detection.
	// For a list of entity types, see how-entities.
	Entities []Entity `type:"list"`
}

// String returns the string representation
func (s DetectEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDetectEntities = "DetectEntities"

// DetectEntitiesRequest returns a request value for making API operation for
// Amazon Comprehend.
//
// Inspects text for named entities, and returns information about them. For
// more information, about named entities, see how-entities.
//
//    // Example sending a request using DetectEntitiesRequest.
//    req := client.DetectEntitiesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectEntities
func (c *Client) DetectEntitiesRequest(input *DetectEntitiesInput) DetectEntitiesRequest {
	op := &aws.Operation{
		Name:       opDetectEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectEntitiesInput{}
	}

	req := c.newRequest(op, input, &DetectEntitiesOutput{})
	return DetectEntitiesRequest{Request: req, Input: input, Copy: c.DetectEntitiesRequest}
}

// DetectEntitiesRequest is the request type for the
// DetectEntities API operation.
type DetectEntitiesRequest struct {
	*aws.Request
	Input *DetectEntitiesInput
	Copy  func(*DetectEntitiesInput) DetectEntitiesRequest
}

// Send marshals and sends the DetectEntities API request.
func (r DetectEntitiesRequest) Send(ctx context.Context) (*DetectEntitiesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DetectEntitiesResponse{
		DetectEntitiesOutput: r.Request.Data.(*DetectEntitiesOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DetectEntitiesResponse is the response type for the
// DetectEntities API operation.
type DetectEntitiesResponse struct {
	*DetectEntitiesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DetectEntities request.
func (r *DetectEntitiesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
