// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectDominantLanguageItemResult struct {
	_ struct{} `type:"structure"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`

	// One or more DominantLanguage objects describing the dominant languages in
	// the document.
	Languages []DominantLanguage `type:"list"`
}

// String returns the string representation
func (s BatchDetectDominantLanguageItemResult) String() string {
	return awsutil.Prettify(s)
}

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectEntitiesItemResult struct {
	_ struct{} `type:"structure"`

	// One or more Entity objects, one for each entity detected in the document.
	Entities []Entity `type:"list"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`
}

// String returns the string representation
func (s BatchDetectEntitiesItemResult) String() string {
	return awsutil.Prettify(s)
}

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectKeyPhrasesItemResult struct {
	_ struct{} `type:"structure"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`

	// One or more KeyPhrase objects, one for each key phrase detected in the document.
	KeyPhrases []KeyPhrase `type:"list"`
}

// String returns the string representation
func (s BatchDetectKeyPhrasesItemResult) String() string {
	return awsutil.Prettify(s)
}

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectSentimentItemResult struct {
	_ struct{} `type:"structure"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`

	// The sentiment detected in the document.
	Sentiment SentimentType `type:"string" enum:"true"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// sentiment detection.
	SentimentScore *SentimentScore `type:"structure"`
}

// String returns the string representation
func (s BatchDetectSentimentItemResult) String() string {
	return awsutil.Prettify(s)
}

// The result of calling the operation. The operation returns one object that
// is successfully processed by the operation.
type BatchDetectSyntaxItemResult struct {
	_ struct{} `type:"structure"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`

	// The syntax tokens for the words in the document, one token for each word.
	SyntaxTokens []SyntaxToken `type:"list"`
}

// String returns the string representation
func (s BatchDetectSyntaxItemResult) String() string {
	return awsutil.Prettify(s)
}

// Describes an error that occurred while processing a document in a batch.
// The operation returns on BatchItemError object for each document that contained
// an error.
type BatchItemError struct {
	_ struct{} `type:"structure"`

	// The numeric error code of the error.
	ErrorCode *string `min:"1" type:"string"`

	// A text description of the error.
	ErrorMessage *string `min:"1" type:"string"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`
}

// String returns the string representation
func (s BatchItemError) String() string {
	return awsutil.Prettify(s)
}

// Describes the result metrics for the test data associated with an documentation
// classifier.
type ClassifierEvaluationMetrics struct {
	_ struct{} `type:"structure"`

	// The fraction of the labels that were correct recognized. It is computed by
	// dividing the number of labels in the test documents that were correctly recognized
	// by the total number of labels in the test documents.
	Accuracy *float64 `type:"double"`

	// A measure of how accurate the classifier results are for the test data. It
	// is derived from the Precision and Recall values. The F1Score is the harmonic
	// average of the two scores. The highest score is 1, and the worst score is
	// 0.
	F1Score *float64 `type:"double"`

	// A measure of the usefulness of the classifier results in the test data. High
	// precision means that the classifier returned substantially more relevant
	// results than irrelevant ones.
	Precision *float64 `type:"double"`

	// A measure of how complete the classifier results are for the test data. High
	// recall means that the classifier returned most of the relevant results.
	Recall *float64 `type:"double"`
}

// String returns the string representation
func (s ClassifierEvaluationMetrics) String() string {
	return awsutil.Prettify(s)
}

// Provides information about a document classifier.
type ClassifierMetadata struct {
	_ struct{} `type:"structure"`

	// Describes the result metrics for the test data associated with an documentation
	// classifier.
	EvaluationMetrics *ClassifierEvaluationMetrics `type:"structure"`

	// The number of labels in the input data.
	NumberOfLabels *int64 `type:"integer"`

	// The number of documents in the input data that were used to test the classifier.
	// Typically this is 10 to 20 percent of the input documents.
	NumberOfTestDocuments *int64 `type:"integer"`

	// The number of documents in the input data that were used to train the classifier.
	// Typically this is 80 to 90 percent of the input documents.
	NumberOfTrainedDocuments *int64 `type:"integer"`
}

// String returns the string representation
func (s ClassifierMetadata) String() string {
	return awsutil.Prettify(s)
}

// Specifies the class that categorizes the document being analyzed
type DocumentClass struct {
	_ struct{} `type:"structure"`

	// The name of the class.
	Name *string `min:"1" type:"string"`

	// The confidence score that Amazon Comprehend has this class correctly attributed.
	Score *float64 `type:"float"`
}

// String returns the string representation
func (s DocumentClass) String() string {
	return awsutil.Prettify(s)
}

// Provides information for filtering a list of document classification jobs.
// For more information, see the operation. You can provide only one filter
// parameter in each request.
type DocumentClassificationJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list based on job status. Returns only jobs with the specified
	// status.
	JobStatus JobStatus `type:"string" enum:"true"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DocumentClassificationJobFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentClassificationJobFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DocumentClassificationJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about a document classification job.
type DocumentClassificationJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS identity and Access Management
	// (IAM) role that grants Amazon Comprehend read access to your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The Amazon Resource Name (ARN) that identifies the document classifier.
	DocumentClassifierArn *string `type:"string"`

	// The time that the document classification job completed.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the document
	// classification job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the document classification job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned to the document classification job.
	JobName *string `min:"1" type:"string"`

	// The current status of the document classification job. If the status is FAILED,
	// the Message field shows the reason for the failure.
	JobStatus JobStatus `type:"string" enum:"true"`

	// A description of the status of the job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the document
	// classification job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the document classification job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your document classification job. For more
	// information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s DocumentClassificationJobProperties) String() string {
	return awsutil.Prettify(s)
}

// Provides information for filtering a list of document classifiers. You can
// only specify one filtering parameter in a request. For more information,
// see the operation.
type DocumentClassifierFilter struct {
	_ struct{} `type:"structure"`

	// Filters the list of classifiers based on status.
	Status ModelStatus `type:"string" enum:"true"`

	// Filters the list of classifiers based on the time that the classifier was
	// submitted for processing. Returns only classifiers submitted after the specified
	// time. Classifiers are returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of classifiers based on the time that the classifier was
	// submitted for processing. Returns only classifiers submitted before the specified
	// time. Classifiers are returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DocumentClassifierFilter) String() string {
	return awsutil.Prettify(s)
}

// The input properties for training a document classifier.
//
// For more information on how the input file is formatted, see how-document-classification-training-data.
type DocumentClassifierInputDataConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 URI for the input data. The S3 bucket must be in the same region
	// as the API endpoint that you are calling. The URI can point to a single input
	// file or it can provide the prefix for a collection of input files.
	//
	// For example, if you use the URI S3://bucketName/prefix, if the prefix is
	// a single file, Amazon Comprehend uses that file as input. If more than one
	// file begins with the prefix, Amazon Comprehend uses all of them as input.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DocumentClassifierInputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentClassifierInputDataConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DocumentClassifierInputDataConfig"}

	if s.S3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides output results configuration parameters for custom classifier jobs.
type DocumentClassifierOutputDataConfig struct {
	_ struct{} `type:"structure"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt the output results from an analysis job. The KmsKeyId can be one
	// of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * KMS Key Alias: "alias/ExampleAlias"
	//
	//    * ARN of a KMS Key Alias: "arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"
	KmsKeyId *string `type:"string"`

	// When you use the OutputDataConfig object while creating a custom classifier,
	// you specify the Amazon S3 location where you want to write the confusion
	// matrix. The URI must be in the same region as the API endpoint that you are
	// calling. The location is used as the prefix for the actual location of this
	// output file.
	//
	// When the custom classifier job is finished, the service creates the output
	// file in a directory specific to the job. The S3Uri field contains the location
	// of the output file, called output.tar.gz. It is a compressed archive that
	// contains the confusion matrix.
	S3Uri *string `type:"string"`
}

// String returns the string representation
func (s DocumentClassifierOutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// Provides information about a document classifier.
type DocumentClassifierProperties struct {
	_ struct{} `type:"structure"`

	// Information about the document classifier, including the number of documents
	// used for training the classifier, the number of documents used for test the
	// classifier, and an accuracy rating.
	ClassifierMetadata *ClassifierMetadata `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role
	// that grants Amazon Comprehend read access to your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The Amazon Resource Name (ARN) that identifies the document classifier.
	DocumentClassifierArn *string `type:"string"`

	// The time that training the document classifier completed.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the document
	// classifier for training.
	InputDataConfig *DocumentClassifierInputDataConfig `type:"structure"`

	// The language code for the language of the documents that the classifier was
	// trained on.
	LanguageCode LanguageCode `type:"string" enum:"true"`

	// Additional information about the status of the classifier.
	Message *string `type:"string"`

	// Provides output results configuration parameters for custom classifier jobs.
	OutputDataConfig *DocumentClassifierOutputDataConfig `type:"structure"`

	// The status of the document classifier. If the status is TRAINED the classifier
	// is ready to use. If the status is FAILED you can see additional information
	// about why the classifier wasn't trained in the Message field.
	Status ModelStatus `type:"string" enum:"true"`

	// The time that the document classifier was submitted for training.
	SubmitTime *time.Time `type:"timestamp"`

	// The time that training of the document classifier was completed. Indicates
	// the time when the training completes on documentation classifiers. You are
	// billed for the time interval between this time and the value of TrainingStartTime.
	TrainingEndTime *time.Time `type:"timestamp"`

	// Indicates the time when the training starts on documentation classifiers.
	// You are billed for the time interval between this time and the value of TrainingEndTime.
	TrainingStartTime *time.Time `type:"timestamp"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your custom classifier. For more information,
	// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s DocumentClassifierProperties) String() string {
	return awsutil.Prettify(s)
}

// Returns the code for the dominant language in the input text and the level
// of confidence that Amazon Comprehend has in the accuracy of the detection.
type DominantLanguage struct {
	_ struct{} `type:"structure"`

	// The RFC 5646 language code for the dominant language. For more information
	// about RFC 5646, see Tags for Identifying Languages (https://tools.ietf.org/html/rfc5646)
	// on the IETF Tools web site.
	LanguageCode *string `min:"1" type:"string"`

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`
}

// String returns the string representation
func (s DominantLanguage) String() string {
	return awsutil.Prettify(s)
}

// Provides information for filtering a list of dominant language detection
// jobs. For more information, see the operation.
type DominantLanguageDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus JobStatus `type:"string" enum:"true"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DominantLanguageDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DominantLanguageDetectionJobFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DominantLanguageDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about a dominant language detection job.
type DominantLanguageDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to
	// your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the dominant language detection job completed.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the dominant
	// language detection job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the dominant language detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned to the dominant language detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the dominant language detection job. If the status
	// is FAILED, the Message field shows the reason for the failure.
	JobStatus JobStatus `type:"string" enum:"true"`

	// A description for the status of a job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the dominant
	// language detection job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the dominant language detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your dominant language detection job. For
	// more information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s DominantLanguageDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// The filter used to determine which endpoints are are returned. You can filter
// jobs on their name, model, status, or the date and time that they were created.
// You can only set one filter at a time.
type EndpointFilter struct {
	_ struct{} `type:"structure"`

	// Specifies a date after which the returned endpoint or endpoints were created.
	CreationTimeAfter *time.Time `type:"timestamp"`

	// Specifies a date before which the returned endpoint or endpoints were created.
	CreationTimeBefore *time.Time `type:"timestamp"`

	// The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
	ModelArn *string `type:"string"`

	// Specifies the status of the endpoint being returned. Possible values are:
	// Creating, Ready, Updating, Deleting, Failed.
	Status EndpointStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s EndpointFilter) String() string {
	return awsutil.Prettify(s)
}

// Specifies information about the specified endpoint.
type EndpointProperties struct {
	_ struct{} `type:"structure"`

	// The creation date and time of the endpoint.
	CreationTime *time.Time `type:"timestamp"`

	// The number of inference units currently used by the model using this endpoint.
	CurrentInferenceUnits *int64 `min:"1" type:"integer"`

	// The desired number of inference units to be used by the model using this
	// endpoint. Each inference unit represents of a throughput of 100 characters
	// per second.
	DesiredInferenceUnits *int64 `min:"1" type:"integer"`

	// The Amazon Resource Number (ARN) of the endpoint.
	EndpointArn *string `type:"string"`

	// The date and time that the endpoint was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// Specifies a reason for failure in cases of Failed status.
	Message *string `type:"string"`

	// The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
	ModelArn *string `type:"string"`

	// Specifies the status of the endpoint. Because the endpoint updates and creation
	// are asynchronous, so customers will need to wait for the endpoint to be Ready
	// status before making inference requests.
	Status EndpointStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s EndpointProperties) String() string {
	return awsutil.Prettify(s)
}

// Provides information for filtering a list of dominant language detection
// jobs. For more information, see the operation.
type EntitiesDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus JobStatus `type:"string" enum:"true"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s EntitiesDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntitiesDetectionJobFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EntitiesDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about an entities detection job.
type EntitiesDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to
	// your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the entities detection job completed
	EndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) that identifies the entity recognizer.
	EntityRecognizerArn *string `type:"string"`

	// The input data configuration that you supplied when you created the entities
	// detection job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the entities detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned the entities detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the entities detection job. If the status is FAILED,
	// the Message field shows the reason for the failure.
	JobStatus JobStatus `type:"string" enum:"true"`

	// The language code of the input documents.
	LanguageCode LanguageCode `type:"string" enum:"true"`

	// A description of the status of a job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the entities
	// detection job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the entities detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your entity detection job. For more information,
	// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s EntitiesDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// Provides information about an entity.
type Entity struct {
	_ struct{} `type:"structure"`

	// A character offset in the input text that shows where the entity begins (the
	// first character is at position 0). The offset returns the position of each
	// UTF-8 code point in the string. A code point is the abstract character from
	// a particular graphical representation. For example, a multi-byte UTF-8 character
	// maps to a single code point.
	BeginOffset *int64 `type:"integer"`

	// A character offset in the input text that shows where the entity ends. The
	// offset returns the position of each UTF-8 code point in the string. A code
	// point is the abstract character from a particular graphical representation.
	// For example, a multi-byte UTF-8 character maps to a single code point.
	EndOffset *int64 `type:"integer"`

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`

	// The text of the entity.
	Text *string `min:"1" type:"string"`

	// The entity's type.
	Type EntityType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Entity) String() string {
	return awsutil.Prettify(s)
}

// Describes the annotations associated with a entity recognizer.
type EntityRecognizerAnnotations struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon S3 location where the annotations for an entity recognizer
	// are located. The URI must be in the same region as the API endpoint that
	// you are calling.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EntityRecognizerAnnotations) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityRecognizerAnnotations) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EntityRecognizerAnnotations"}

	if s.S3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the training documents submitted with an entity recognizer.
type EntityRecognizerDocuments struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon S3 location where the training documents for an entity
	// recognizer are located. The URI must be in the same region as the API endpoint
	// that you are calling.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EntityRecognizerDocuments) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityRecognizerDocuments) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EntityRecognizerDocuments"}

	if s.S3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the entity recognizer submitted with an entity recognizer.
type EntityRecognizerEntityList struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon S3 location where the entity list is located. The URI
	// must be in the same region as the API endpoint that you are calling.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EntityRecognizerEntityList) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityRecognizerEntityList) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EntityRecognizerEntityList"}

	if s.S3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Detailed information about the accuracy of an entity recognizer.
type EntityRecognizerEvaluationMetrics struct {
	_ struct{} `type:"structure"`

	// A measure of how accurate the recognizer results are for the test data. It
	// is derived from the Precision and Recall values. The F1Score is the harmonic
	// average of the two scores. The highest score is 1, and the worst score is
	// 0.
	F1Score *float64 `type:"double"`

	// A measure of the usefulness of the recognizer results in the test data. High
	// precision means that the recognizer returned substantially more relevant
	// results than irrelevant ones.
	Precision *float64 `type:"double"`

	// A measure of how complete the recognizer results are for the test data. High
	// recall means that the recognizer returned most of the relevant results.
	Recall *float64 `type:"double"`
}

// String returns the string representation
func (s EntityRecognizerEvaluationMetrics) String() string {
	return awsutil.Prettify(s)
}

// Provides information for filtering a list of entity recognizers. You can
// only specify one filtering parameter in a request. For more information,
// see the operation./>
type EntityRecognizerFilter struct {
	_ struct{} `type:"structure"`

	// The status of an entity recognizer.
	Status ModelStatus `type:"string" enum:"true"`

	// Filters the list of entities based on the time that the list was submitted
	// for processing. Returns only jobs submitted after the specified time. Jobs
	// are returned in ascending order, oldest to newest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of entities based on the time that the list was submitted
	// for processing. Returns only jobs submitted before the specified time. Jobs
	// are returned in descending order, newest to oldest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s EntityRecognizerFilter) String() string {
	return awsutil.Prettify(s)
}

// Specifies the format and location of the input data.
type EntityRecognizerInputDataConfig struct {
	_ struct{} `type:"structure"`

	// S3 location of the annotations file for an entity recognizer.
	Annotations *EntityRecognizerAnnotations `type:"structure"`

	// S3 location of the documents folder for an entity recognizer
	//
	// Documents is a required field
	Documents *EntityRecognizerDocuments `type:"structure" required:"true"`

	// S3 location of the entity list for an entity recognizer.
	EntityList *EntityRecognizerEntityList `type:"structure"`

	// The entity types in the input data for an entity recognizer. A maximum of
	// 12 entity types can be used at one time to train an entity recognizer.
	//
	// EntityTypes is a required field
	EntityTypes []EntityTypesListItem `type:"list" required:"true"`
}

// String returns the string representation
func (s EntityRecognizerInputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityRecognizerInputDataConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EntityRecognizerInputDataConfig"}

	if s.Documents == nil {
		invalidParams.Add(aws.NewErrParamRequired("Documents"))
	}

	if s.EntityTypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("EntityTypes"))
	}
	if s.Annotations != nil {
		if err := s.Annotations.Validate(); err != nil {
			invalidParams.AddNested("Annotations", err.(aws.ErrInvalidParams))
		}
	}
	if s.Documents != nil {
		if err := s.Documents.Validate(); err != nil {
			invalidParams.AddNested("Documents", err.(aws.ErrInvalidParams))
		}
	}
	if s.EntityList != nil {
		if err := s.EntityList.Validate(); err != nil {
			invalidParams.AddNested("EntityList", err.(aws.ErrInvalidParams))
		}
	}
	if s.EntityTypes != nil {
		for i, v := range s.EntityTypes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EntityTypes", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Detailed information about an entity recognizer.
type EntityRecognizerMetadata struct {
	_ struct{} `type:"structure"`

	// Entity types from the metadata of an entity recognizer.
	EntityTypes []EntityRecognizerMetadataEntityTypesListItem `type:"list"`

	// Detailed information about the accuracy of an entity recognizer.
	EvaluationMetrics *EntityRecognizerEvaluationMetrics `type:"structure"`

	// The number of documents in the input data that were used to test the entity
	// recognizer. Typically this is 10 to 20 percent of the input documents.
	NumberOfTestDocuments *int64 `type:"integer"`

	// The number of documents in the input data that were used to train the entity
	// recognizer. Typically this is 80 to 90 percent of the input documents.
	NumberOfTrainedDocuments *int64 `type:"integer"`
}

// String returns the string representation
func (s EntityRecognizerMetadata) String() string {
	return awsutil.Prettify(s)
}

// Individual item from the list of entity types in the metadata of an entity
// recognizer.
type EntityRecognizerMetadataEntityTypesListItem struct {
	_ struct{} `type:"structure"`

	// Detailed information about the accuracy of the entity recognizer for a specific
	// item on the list of entity types.
	EvaluationMetrics *EntityTypesEvaluationMetrics `type:"structure"`

	// Indicates the number of times the given entity type was seen in the training
	// data.
	NumberOfTrainMentions *int64 `type:"integer"`

	// Type of entity from the list of entity types in the metadata of an entity
	// recognizer.
	Type *string `type:"string"`
}

// String returns the string representation
func (s EntityRecognizerMetadataEntityTypesListItem) String() string {
	return awsutil.Prettify(s)
}

// Describes information about an entity recognizer.
type EntityRecognizerProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role
	// that grants Amazon Comprehend read access to your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the recognizer creation completed.
	EndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) that identifies the entity recognizer.
	EntityRecognizerArn *string `type:"string"`

	// The input data properties of an entity recognizer.
	InputDataConfig *EntityRecognizerInputDataConfig `type:"structure"`

	// The language of the input documents. All documents must be in the same language.
	// Only English ("en") is currently supported.
	LanguageCode LanguageCode `type:"string" enum:"true"`

	// A description of the status of the recognizer.
	Message *string `type:"string"`

	// Provides information about an entity recognizer.
	RecognizerMetadata *EntityRecognizerMetadata `type:"structure"`

	// Provides the status of the entity recognizer.
	Status ModelStatus `type:"string" enum:"true"`

	// The time that the recognizer was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// The time that training of the entity recognizer was completed.
	TrainingEndTime *time.Time `type:"timestamp"`

	// The time that training of the entity recognizer started.
	TrainingStartTime *time.Time `type:"timestamp"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your custom entity recognizer. For more information,
	// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s EntityRecognizerProperties) String() string {
	return awsutil.Prettify(s)
}

// Detailed information about the accuracy of an entity recognizer for a specific
// entity type.
type EntityTypesEvaluationMetrics struct {
	_ struct{} `type:"structure"`

	// A measure of how accurate the recognizer results are for for a specific entity
	// type in the test data. It is derived from the Precision and Recall values.
	// The F1Score is the harmonic average of the two scores. The highest score
	// is 1, and the worst score is 0.
	F1Score *float64 `type:"double"`

	// A measure of the usefulness of the recognizer results for a specific entity
	// type in the test data. High precision means that the recognizer returned
	// substantially more relevant results than irrelevant ones.
	Precision *float64 `type:"double"`

	// A measure of how complete the recognizer results are for a specific entity
	// type in the test data. High recall means that the recognizer returned most
	// of the relevant results.
	Recall *float64 `type:"double"`
}

// String returns the string representation
func (s EntityTypesEvaluationMetrics) String() string {
	return awsutil.Prettify(s)
}

// Information about an individual item on a list of entity types.
type EntityTypesListItem struct {
	_ struct{} `type:"structure"`

	// Entity type of an item on an entity type list.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EntityTypesListItem) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityTypesListItem) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EntityTypesListItem"}

	if s.Type == nil {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The input properties for a topic detection job.
type InputDataConfig struct {
	_ struct{} `type:"structure"`

	// Specifies how the text in an input file should be processed:
	//
	//    * ONE_DOC_PER_FILE - Each file is considered a separate document. Use
	//    this option when you are processing large documents, such as newspaper
	//    articles or scientific papers.
	//
	//    * ONE_DOC_PER_LINE - Each line in a file is considered a separate document.
	//    Use this option when you are processing many short documents, such as
	//    text messages.
	InputFormat InputFormat `type:"string" enum:"true"`

	// The Amazon S3 URI for the input data. The URI must be in same region as the
	// API endpoint that you are calling. The URI can point to a single input file
	// or it can provide the prefix for a collection of data files.
	//
	// For example, if you use the URI S3://bucketName/prefix, if the prefix is
	// a single file, Amazon Comprehend uses that file as input. If more than one
	// file begins with the prefix, Amazon Comprehend uses all of them as input.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputDataConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputDataConfig"}

	if s.S3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a key noun phrase.
type KeyPhrase struct {
	_ struct{} `type:"structure"`

	// A character offset in the input text that shows where the key phrase begins
	// (the first character is at position 0). The offset returns the position of
	// each UTF-8 code point in the string. A code point is the abstract character
	// from a particular graphical representation. For example, a multi-byte UTF-8
	// character maps to a single code point.
	BeginOffset *int64 `type:"integer"`

	// A character offset in the input text where the key phrase ends. The offset
	// returns the position of each UTF-8 code point in the string. A code point
	// is the abstract character from a particular graphical representation. For
	// example, a multi-byte UTF-8 character maps to a single code point.
	EndOffset *int64 `type:"integer"`

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`

	// The text of a key noun phrase.
	Text *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KeyPhrase) String() string {
	return awsutil.Prettify(s)
}

// Provides information for filtering a list of dominant language detection
// jobs. For more information, see the operation.
type KeyPhrasesDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus JobStatus `type:"string" enum:"true"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s KeyPhrasesDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeyPhrasesDetectionJobFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KeyPhrasesDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about a key phrases detection job.
type KeyPhrasesDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to
	// your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the key phrases detection job completed.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the key phrases
	// detection job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the key phrases detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned the key phrases detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the key phrases detection job. If the status is FAILED,
	// the Message field shows the reason for the failure.
	JobStatus JobStatus `type:"string" enum:"true"`

	// The language code of the input documents.
	LanguageCode LanguageCode `type:"string" enum:"true"`

	// A description of the status of a job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the key
	// phrases detection job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the key phrases detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your key phrases detection job. For more
	// information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s KeyPhrasesDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// Provides configuration parameters for the output of topic detection jobs.
type OutputDataConfig struct {
	_ struct{} `type:"structure"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt the output results from an analysis job. The KmsKeyId can be one
	// of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * KMS Key Alias: "alias/ExampleAlias"
	//
	//    * ARN of a KMS Key Alias: "arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"
	KmsKeyId *string `type:"string"`

	// When you use the OutputDataConfig object with asynchronous operations, you
	// specify the Amazon S3 location where you want to write the output data. The
	// URI must be in the same region as the API endpoint that you are calling.
	// The location is used as the prefix for the actual location of the output
	// file.
	//
	// When the topic detection job is finished, the service creates an output file
	// in a directory specific to the job. The S3Uri field contains the location
	// of the output file, called output.tar.gz. It is a compressed archive that
	// contains the ouput of the operation.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputDataConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputDataConfig"}

	if s.S3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Identifies the part of speech represented by the token and gives the confidence
// that Amazon Comprehend has that the part of speech was correctly identified.
// For more information about the parts of speech that Amazon Comprehend can
// identify, see how-syntax.
type PartOfSpeechTag struct {
	_ struct{} `type:"structure"`

	// The confidence that Amazon Comprehend has that the part of speech was correctly
	// identified.
	Score *float64 `type:"float"`

	// Identifies the part of speech that the token represents.
	Tag PartOfSpeechTagType `type:"string" enum:"true"`
}

// String returns the string representation
func (s PartOfSpeechTag) String() string {
	return awsutil.Prettify(s)
}

// Provides information for filtering a list of dominant language detection
// jobs. For more information, see the operation.
type SentimentDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus JobStatus `type:"string" enum:"true"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s SentimentDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SentimentDetectionJobFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SentimentDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about a sentiment detection job.
type SentimentDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to
	// your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the sentiment detection job ended.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the sentiment
	// detection job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the sentiment detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned to the sentiment detection job
	JobName *string `min:"1" type:"string"`

	// The current status of the sentiment detection job. If the status is FAILED,
	// the Messages field shows the reason for the failure.
	JobStatus JobStatus `type:"string" enum:"true"`

	// The language code of the input documents.
	LanguageCode LanguageCode `type:"string" enum:"true"`

	// A description of the status of a job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the sentiment
	// detection job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the sentiment detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your sentiment detection job. For more information,
	// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s SentimentDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// Describes the level of confidence that Amazon Comprehend has in the accuracy
// of its detection of sentiments.
type SentimentScore struct {
	_ struct{} `type:"structure"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the MIXED sentiment.
	Mixed *float64 `type:"float"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the NEGATIVE sentiment.
	Negative *float64 `type:"float"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the NEUTRAL sentiment.
	Neutral *float64 `type:"float"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the POSITIVE sentiment.
	Positive *float64 `type:"float"`
}

// String returns the string representation
func (s SentimentScore) String() string {
	return awsutil.Prettify(s)
}

// Represents a work in the input text that was recognized and assigned a part
// of speech. There is one syntax token record for each word in the source text.
type SyntaxToken struct {
	_ struct{} `type:"structure"`

	// The zero-based offset from the beginning of the source text to the first
	// character in the word.
	BeginOffset *int64 `type:"integer"`

	// The zero-based offset from the beginning of the source text to the last character
	// in the word.
	EndOffset *int64 `type:"integer"`

	// Provides the part of speech label and the confidence level that Amazon Comprehend
	// has that the part of speech was correctly identified. For more information,
	// see how-syntax.
	PartOfSpeech *PartOfSpeechTag `type:"structure"`

	// The word that was recognized in the source text.
	Text *string `min:"1" type:"string"`

	// A unique identifier for a token.
	TokenId *int64 `type:"integer"`
}

// String returns the string representation
func (s SyntaxToken) String() string {
	return awsutil.Prettify(s)
}

// A key-value pair that adds as a metadata to a resource used by Amazon Comprehend.
// For example, a tag with the key-value pair ‘Department’:’Sales’ might
// be added to a resource to indicate its use by a particular department.
type Tag struct {
	_ struct{} `type:"structure"`

	// The initial part of a key-value pair that forms a tag associated with a given
	// resource. For instance, if you want to show which resources are used by which
	// departments, you might use “Department” as the key portion of the pair,
	// with multiple possible values such as “sales,” “legal,” and “administration.”
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The second part of a key-value pair that forms a tag associated with a given
	// resource. For instance, if you want to show which resources are used by which
	// departments, you might use “Department” as the initial (key) portion
	// of the pair, with a value of “sales” to indicate the sales department.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information for filtering topic detection jobs. For more information,
// see .
type TopicsDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	JobName *string `min:"1" type:"string"`

	// Filters the list of topic detection jobs based on job status. Returns only
	// jobs with the specified status.
	JobStatus JobStatus `type:"string" enum:"true"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Only returns jobs submitted after the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Only returns jobs submitted before the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s TopicsDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TopicsDetectionJobFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TopicsDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about a topic detection job.
type TopicsDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role
	// that grants Amazon Comprehend read access to your job data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the topic detection job was completed.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration supplied when you created the topic detection
	// job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the topic detection job.
	JobId *string `min:"1" type:"string"`

	// The name of the topic detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the topic detection job. If the status is Failed, the
	// reason for the failure is shown in the Message field.
	JobStatus JobStatus `type:"string" enum:"true"`

	// A description for the status of a job.
	Message *string `type:"string"`

	// The number of topics to detect supplied when you created the topic detection
	// job. The default is 10.
	NumberOfTopics *int64 `type:"integer"`

	// The output data configuration supplied when you created the topic detection
	// job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the topic detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your topic detection job. For more information,
	// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s TopicsDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// Configuration parameters for an optional private Virtual Private Cloud (VPC)
// containing the resources you are using for the job. For For more information,
// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
type VpcConfig struct {
	_ struct{} `type:"structure"`

	// The ID number for a security group on an instance of your private VPC. Security
	// groups on your VPC function serve as a virtual firewall to control inbound
	// and outbound traffic and provides security for the resources that you’ll
	// be accessing on the VPC. This ID number is preceded by "sg-", for instance:
	// "sg-03b388029b0a285ea". For more information, see Security Groups for your
	// VPC (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html).
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []string `min:"1" type:"list" required:"true"`

	// The ID for each subnet being used in your private VPC. This subnet is a subset
	// of the a range of IPv4 addresses used by the VPC and is specific to a given
	// availability zone in the VPC’s region. This ID number is preceded by "subnet-",
	// for instance: "subnet-04ccf456919e69055". For more information, see VPCs
	// and Subnets (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html).
	//
	// Subnets is a required field
	Subnets []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s VpcConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VpcConfig"}

	if s.SecurityGroupIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecurityGroupIds", 1))
	}

	if s.Subnets == nil {
		invalidParams.Add(aws.NewErrParamRequired("Subnets"))
	}
	if s.Subnets != nil && len(s.Subnets) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Subnets", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
