// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CompleteLayerUploadInput struct {
	_ struct{} `type:"structure"`

	// The sha256 digest of the image layer.
	//
	// LayerDigests is a required field
	LayerDigests []string `locationName:"layerDigests" min:"1" type:"list" required:"true"`

	// The AWS account ID associated with the registry to which to upload layers.
	// If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository to associate with the image layer.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`

	// The upload ID from a previous InitiateLayerUpload operation to associate
	// with the image layer.
	//
	// UploadId is a required field
	UploadId *string `locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s CompleteLayerUploadInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteLayerUploadInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CompleteLayerUploadInput"}

	if s.LayerDigests == nil {
		invalidParams.Add(aws.NewErrParamRequired("LayerDigests"))
	}
	if s.LayerDigests != nil && len(s.LayerDigests) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LayerDigests", 1))
	}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 2))
	}

	if s.UploadId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CompleteLayerUploadOutput struct {
	_ struct{} `type:"structure"`

	// The sha256 digest of the image layer.
	LayerDigest *string `locationName:"layerDigest" type:"string"`

	// The registry ID associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`

	// The upload ID associated with the layer.
	UploadId *string `locationName:"uploadId" type:"string"`
}

// String returns the string representation
func (s CompleteLayerUploadOutput) String() string {
	return awsutil.Prettify(s)
}

const opCompleteLayerUpload = "CompleteLayerUpload"

// CompleteLayerUploadRequest returns a request value for making API operation for
// Amazon EC2 Container Registry.
//
// Informs Amazon ECR that the image layer upload has completed for a specified
// registry, repository name, and upload ID. You can optionally provide a sha256
// digest of the image layer for data validation purposes.
//
// This operation is used by the Amazon ECR proxy, and it is not intended for
// general use by customers for pulling and pushing images. In most cases, you
// should use the docker CLI to pull, tag, and push images.
//
//    // Example sending a request using CompleteLayerUploadRequest.
//    req := client.CompleteLayerUploadRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CompleteLayerUpload
func (c *Client) CompleteLayerUploadRequest(input *CompleteLayerUploadInput) CompleteLayerUploadRequest {
	op := &aws.Operation{
		Name:       opCompleteLayerUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CompleteLayerUploadInput{}
	}

	req := c.newRequest(op, input, &CompleteLayerUploadOutput{})
	return CompleteLayerUploadRequest{Request: req, Input: input, Copy: c.CompleteLayerUploadRequest}
}

// CompleteLayerUploadRequest is the request type for the
// CompleteLayerUpload API operation.
type CompleteLayerUploadRequest struct {
	*aws.Request
	Input *CompleteLayerUploadInput
	Copy  func(*CompleteLayerUploadInput) CompleteLayerUploadRequest
}

// Send marshals and sends the CompleteLayerUpload API request.
func (r CompleteLayerUploadRequest) Send(ctx context.Context) (*CompleteLayerUploadResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CompleteLayerUploadResponse{
		CompleteLayerUploadOutput: r.Request.Data.(*CompleteLayerUploadOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CompleteLayerUploadResponse is the response type for the
// CompleteLayerUpload API operation.
type CompleteLayerUploadResponse struct {
	*CompleteLayerUploadOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CompleteLayerUpload request.
func (r *CompleteLayerUploadResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
