// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glacier

import (
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Contains information about the comma-separated value (CSV) file to select
// from.
type CSVInput struct {
	_ struct{} `type:"structure"`

	// A single character used to indicate that a row should be ignored when the
	// character is present at the start of that row.
	Comments *string `type:"string"`

	// A value used to separate individual fields from each other within a record.
	FieldDelimiter *string `type:"string"`

	// Describes the first line of input. Valid values are None, Ignore, and Use.
	FileHeaderInfo FileHeaderInfo `type:"string" enum:"true"`

	// A value used as an escape character where the field delimiter is part of
	// the value.
	QuoteCharacter *string `type:"string"`

	// A single character used for escaping the quotation-mark character inside
	// an already escaped value.
	QuoteEscapeCharacter *string `type:"string"`

	// A value used to separate individual records from each other.
	RecordDelimiter *string `type:"string"`
}

// String returns the string representation
func (s CSVInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CSVInput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Comments != nil {
		v := *s.Comments

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comments", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FieldDelimiter != nil {
		v := *s.FieldDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FieldDelimiter", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.FileHeaderInfo) > 0 {
		v := s.FileHeaderInfo

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FileHeaderInfo", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.QuoteCharacter != nil {
		v := *s.QuoteCharacter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteCharacter", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.QuoteEscapeCharacter != nil {
		v := *s.QuoteEscapeCharacter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteEscapeCharacter", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RecordDelimiter != nil {
		v := *s.RecordDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecordDelimiter", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the comma-separated value (CSV) file that the
// job results are stored in.
type CSVOutput struct {
	_ struct{} `type:"structure"`

	// A value used to separate individual fields from each other within a record.
	FieldDelimiter *string `type:"string"`

	// A value used as an escape character where the field delimiter is part of
	// the value.
	QuoteCharacter *string `type:"string"`

	// A single character used for escaping the quotation-mark character inside
	// an already escaped value.
	QuoteEscapeCharacter *string `type:"string"`

	// A value that indicates whether all output fields should be contained within
	// quotation marks.
	QuoteFields QuoteFields `type:"string" enum:"true"`

	// A value used to separate individual records from each other.
	RecordDelimiter *string `type:"string"`
}

// String returns the string representation
func (s CSVOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CSVOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.FieldDelimiter != nil {
		v := *s.FieldDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FieldDelimiter", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.QuoteCharacter != nil {
		v := *s.QuoteCharacter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteCharacter", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.QuoteEscapeCharacter != nil {
		v := *s.QuoteEscapeCharacter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteEscapeCharacter", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.QuoteFields) > 0 {
		v := s.QuoteFields

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteFields", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RecordDelimiter != nil {
		v := *s.RecordDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecordDelimiter", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Data retrieval policy.
type DataRetrievalPolicy struct {
	_ struct{} `type:"structure"`

	// The policy rule. Although this is a list type, currently there must be only
	// one rule, which contains a Strategy field and optionally a BytesPerHour field.
	Rules []DataRetrievalRule `type:"list"`
}

// String returns the string representation
func (s DataRetrievalPolicy) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataRetrievalPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.Rules != nil {
		v := s.Rules

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Rules", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Data retrieval policy rule.
type DataRetrievalRule struct {
	_ struct{} `type:"structure"`

	// The maximum number of bytes that can be retrieved in an hour.
	//
	// This field is required only if the value of the Strategy field is BytesPerHour.
	// Your PUT operation will be rejected if the Strategy field is not set to BytesPerHour
	// and you set this field.
	BytesPerHour *int64 `type:"long"`

	// The type of data retrieval policy to set.
	//
	// Valid values: BytesPerHour|FreeTier|None
	Strategy *string `type:"string"`
}

// String returns the string representation
func (s DataRetrievalRule) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataRetrievalRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.BytesPerHour != nil {
		v := *s.BytesPerHour

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BytesPerHour", protocol.Int64Value(v), metadata)
	}
	if s.Strategy != nil {
		v := *s.Strategy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Strategy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the encryption used to store the job results in
// Amazon S3.
type Encryption struct {
	_ struct{} `type:"structure"`

	// The server-side encryption algorithm used when storing job results in Amazon
	// S3, for example AES256 or aws:kms.
	EncryptionType EncryptionType `type:"string" enum:"true"`

	// Optional. If the encryption type is aws:kms, you can use this value to specify
	// the encryption context for the job results.
	KMSContext *string `type:"string"`

	// The AWS KMS key ID to use for object encryption. All GET and PUT requests
	// for an object protected by AWS KMS fail if not made by using Secure Sockets
	// Layer (SSL) or Signature Version 4.
	KMSKeyId *string `type:"string"`
}

// String returns the string representation
func (s Encryption) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Encryption) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.EncryptionType) > 0 {
		v := s.EncryptionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EncryptionType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.KMSContext != nil {
		v := *s.KMSContext

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KMSContext", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KMSKeyId != nil {
		v := *s.KMSKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KMSKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains the description of an Amazon S3 Glacier job.
type GlacierJobDescription struct {
	_ struct{} `type:"structure"`

	// The job type. This value is either ArchiveRetrieval, InventoryRetrieval,
	// or Select.
	Action ActionCode `type:"string" enum:"true"`

	// The archive ID requested for a select job or archive retrieval. Otherwise,
	// this field is null.
	ArchiveId *string `type:"string"`

	// The SHA256 tree hash of the entire archive for an archive retrieval. For
	// inventory retrieval or select jobs, this field is null.
	ArchiveSHA256TreeHash *string `type:"string"`

	// For an archive retrieval job, this value is the size in bytes of the archive
	// being requested for download. For an inventory retrieval or select job, this
	// value is null.
	ArchiveSizeInBytes *int64 `type:"long"`

	// The job status. When a job is completed, you get the job's output using Get
	// Job Output (GET output).
	Completed *bool `type:"boolean"`

	// The UTC time that the job request completed. While the job is in progress,
	// the value is null.
	CompletionDate *string `type:"string"`

	// The UTC date when the job was created. This value is a string representation
	// of ISO 8601 date format, for example "2012-03-20T17:03:43.221Z".
	CreationDate *string `type:"string"`

	// Parameters used for range inventory retrieval.
	InventoryRetrievalParameters *InventoryRetrievalJobDescription `type:"structure"`

	// For an inventory retrieval job, this value is the size in bytes of the inventory
	// requested for download. For an archive retrieval or select job, this value
	// is null.
	InventorySizeInBytes *int64 `type:"long"`

	// The job description provided when initiating the job.
	JobDescription *string `type:"string"`

	// An opaque string that identifies an Amazon S3 Glacier job.
	JobId *string `type:"string"`

	// Contains the job output location.
	JobOutputPath *string `type:"string"`

	// Contains the location where the data from the select job is stored.
	OutputLocation *OutputLocation `type:"structure"`

	// The retrieved byte range for archive retrieval jobs in the form StartByteValue-EndByteValue.
	// If no range was specified in the archive retrieval, then the whole archive
	// is retrieved. In this case, StartByteValue equals 0 and EndByteValue equals
	// the size of the archive minus 1. For inventory retrieval or select jobs,
	// this field is null.
	RetrievalByteRange *string `type:"string"`

	// For an archive retrieval job, this value is the checksum of the archive.
	// Otherwise, this value is null.
	//
	// The SHA256 tree hash value for the requested range of an archive. If the
	// InitiateJob request for an archive specified a tree-hash aligned range, then
	// this field returns a value.
	//
	// If the whole archive is retrieved, this value is the same as the ArchiveSHA256TreeHash
	// value.
	//
	// This field is null for the following:
	//
	//    * Archive retrieval jobs that specify a range that is not tree-hash aligned
	//
	//    * Archival jobs that specify a range that is equal to the whole archive,
	//    when the job status is InProgress
	//
	//    * Inventory jobs
	//
	//    * Select jobs
	SHA256TreeHash *string `type:"string"`

	// An Amazon SNS topic that receives notification.
	SNSTopic *string `type:"string"`

	// Contains the parameters used for a select.
	SelectParameters *SelectParameters `type:"structure"`

	// The status code can be InProgress, Succeeded, or Failed, and indicates the
	// status of the job.
	StatusCode StatusCode `type:"string" enum:"true"`

	// A friendly message that describes the job status.
	StatusMessage *string `type:"string"`

	// The tier to use for a select or an archive retrieval. Valid values are Expedited,
	// Standard, or Bulk. Standard is the default.
	Tier *string `type:"string"`

	// The Amazon Resource Name (ARN) of the vault from which an archive retrieval
	// was requested.
	VaultARN *string `type:"string"`
}

// String returns the string representation
func (s GlacierJobDescription) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GlacierJobDescription) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ArchiveId != nil {
		v := *s.ArchiveId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ArchiveId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ArchiveSHA256TreeHash != nil {
		v := *s.ArchiveSHA256TreeHash

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ArchiveSHA256TreeHash", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ArchiveSizeInBytes != nil {
		v := *s.ArchiveSizeInBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ArchiveSizeInBytes", protocol.Int64Value(v), metadata)
	}
	if s.Completed != nil {
		v := *s.Completed

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Completed", protocol.BoolValue(v), metadata)
	}
	if s.CompletionDate != nil {
		v := *s.CompletionDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompletionDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InventoryRetrievalParameters != nil {
		v := s.InventoryRetrievalParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "InventoryRetrievalParameters", v, metadata)
	}
	if s.InventorySizeInBytes != nil {
		v := *s.InventorySizeInBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InventorySizeInBytes", protocol.Int64Value(v), metadata)
	}
	if s.JobDescription != nil {
		v := *s.JobDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "JobDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JobId != nil {
		v := *s.JobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "JobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JobOutputPath != nil {
		v := *s.JobOutputPath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "JobOutputPath", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OutputLocation != nil {
		v := s.OutputLocation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "OutputLocation", v, metadata)
	}
	if s.RetrievalByteRange != nil {
		v := *s.RetrievalByteRange

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RetrievalByteRange", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SHA256TreeHash != nil {
		v := *s.SHA256TreeHash

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SHA256TreeHash", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SNSTopic != nil {
		v := *s.SNSTopic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SNSTopic", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SelectParameters != nil {
		v := s.SelectParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SelectParameters", v, metadata)
	}
	if len(s.StatusCode) > 0 {
		v := s.StatusCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatusCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StatusMessage != nil {
		v := *s.StatusMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatusMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tier != nil {
		v := *s.Tier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Tier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VaultARN != nil {
		v := *s.VaultARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VaultARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about a grant.
type Grant struct {
	_ struct{} `type:"structure"`

	// The grantee.
	Grantee *Grantee `type:"structure"`

	// Specifies the permission given to the grantee.
	Permission Permission `type:"string" enum:"true"`
}

// String returns the string representation
func (s Grant) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Grant) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Grant"}
	if s.Grantee != nil {
		if err := s.Grantee.Validate(); err != nil {
			invalidParams.AddNested("Grantee", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Grant) MarshalFields(e protocol.FieldEncoder) error {
	if s.Grantee != nil {
		v := s.Grantee

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Grantee", v, metadata)
	}
	if len(s.Permission) > 0 {
		v := s.Permission

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Permission", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains information about the grantee.
type Grantee struct {
	_ struct{} `type:"structure"`

	// Screen name of the grantee.
	DisplayName *string `type:"string"`

	// Email address of the grantee.
	EmailAddress *string `type:"string"`

	// The canonical user ID of the grantee.
	ID *string `type:"string"`

	// Type of grantee
	//
	// Type is a required field
	Type Type `type:"string" required:"true" enum:"true"`

	// URI of the grantee group.
	URI *string `type:"string"`
}

// String returns the string representation
func (s Grantee) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Grantee) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Grantee"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Grantee) MarshalFields(e protocol.FieldEncoder) error {
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EmailAddress != nil {
		v := *s.EmailAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EmailAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.URI != nil {
		v := *s.URI

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "URI", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes how the archive is serialized.
type InputSerialization struct {
	_ struct{} `type:"structure"`

	// Describes the serialization of a CSV-encoded object.
	Csv *CSVInput `locationName:"csv" type:"structure"`
}

// String returns the string representation
func (s InputSerialization) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputSerialization) MarshalFields(e protocol.FieldEncoder) error {
	if s.Csv != nil {
		v := s.Csv

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "csv", v, metadata)
	}
	return nil
}

// Describes the options for a range inventory retrieval job.
type InventoryRetrievalJobDescription struct {
	_ struct{} `type:"structure"`

	// The end of the date range in UTC for vault inventory retrieval that includes
	// archives created before this date. This value should be a string in the ISO
	// 8601 date format, for example 2013-03-20T17:03:43Z.
	EndDate *string `type:"string"`

	// The output format for the vault inventory list, which is set by the InitiateJob
	// request when initiating a job to retrieve a vault inventory. Valid values
	// are CSV and JSON.
	Format *string `type:"string"`

	// The maximum number of inventory items returned per vault inventory retrieval
	// request. This limit is set when initiating the job with the a InitiateJob
	// request.
	Limit *string `type:"string"`

	// An opaque string that represents where to continue pagination of the vault
	// inventory retrieval results. You use the marker in a new InitiateJob request
	// to obtain additional inventory items. If there are no more inventory items,
	// this value is null. For more information, see Range Inventory Retrieval (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html#api-initiate-job-post-vault-inventory-list-filtering).
	Marker *string `type:"string"`

	// The start of the date range in Universal Coordinated Time (UTC) for vault
	// inventory retrieval that includes archives created on or after this date.
	// This value should be a string in the ISO 8601 date format, for example 2013-03-20T17:03:43Z.
	StartDate *string `type:"string"`
}

// String returns the string representation
func (s InventoryRetrievalJobDescription) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventoryRetrievalJobDescription) MarshalFields(e protocol.FieldEncoder) error {
	if s.EndDate != nil {
		v := *s.EndDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Format != nil {
		v := *s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Format", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Limit != nil {
		v := *s.Limit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Limit", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Marker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartDate != nil {
		v := *s.StartDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides options for specifying a range inventory retrieval job.
type InventoryRetrievalJobInput struct {
	_ struct{} `type:"structure"`

	// The end of the date range in UTC for vault inventory retrieval that includes
	// archives created before this date. This value should be a string in the ISO
	// 8601 date format, for example 2013-03-20T17:03:43Z.
	EndDate *string `type:"string"`

	// Specifies the maximum number of inventory items returned per vault inventory
	// retrieval request. Valid values are greater than or equal to 1.
	Limit *string `type:"string"`

	// An opaque string that represents where to continue pagination of the vault
	// inventory retrieval results. You use the marker in a new InitiateJob request
	// to obtain additional inventory items. If there are no more inventory items,
	// this value is null.
	Marker *string `type:"string"`

	// The start of the date range in UTC for vault inventory retrieval that includes
	// archives created on or after this date. This value should be a string in
	// the ISO 8601 date format, for example 2013-03-20T17:03:43Z.
	StartDate *string `type:"string"`
}

// String returns the string representation
func (s InventoryRetrievalJobInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventoryRetrievalJobInput) MarshalFields(e protocol.FieldEncoder) error {
	if s.EndDate != nil {
		v := *s.EndDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Limit != nil {
		v := *s.Limit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Limit", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Marker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartDate != nil {
		v := *s.StartDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides options for defining a job.
type JobParameters struct {
	_ struct{} `type:"structure"`

	// The ID of the archive that you want to retrieve. This field is required only
	// if Type is set to select or archive-retrievalcode>. An error occurs if you
	// specify this request parameter for an inventory retrieval job request.
	ArchiveId *string `type:"string"`

	// The optional description for the job. The description must be less than or
	// equal to 1,024 bytes. The allowable characters are 7-bit ASCII without control
	// codes-specifically, ASCII values 32-126 decimal or 0x20-0x7E hexadecimal.
	Description *string `type:"string"`

	// When initiating a job to retrieve a vault inventory, you can optionally add
	// this parameter to your request to specify the output format. If you are initiating
	// an inventory job and do not specify a Format field, JSON is the default format.
	// Valid values are "CSV" and "JSON".
	Format *string `type:"string"`

	// Input parameters used for range inventory retrieval.
	InventoryRetrievalParameters *InventoryRetrievalJobInput `type:"structure"`

	// Contains information about the location where the select job results are
	// stored.
	OutputLocation *OutputLocation `type:"structure"`

	// The byte range to retrieve for an archive retrieval. in the form "StartByteValue-EndByteValue"
	// If not specified, the whole archive is retrieved. If specified, the byte
	// range must be megabyte (1024*1024) aligned which means that StartByteValue
	// must be divisible by 1 MB and EndByteValue plus 1 must be divisible by 1
	// MB or be the end of the archive specified as the archive byte size value
	// minus 1. If RetrievalByteRange is not megabyte aligned, this operation returns
	// a 400 response.
	//
	// An error occurs if you specify this field for an inventory retrieval job
	// request.
	RetrievalByteRange *string `type:"string"`

	// The Amazon SNS topic ARN to which Amazon S3 Glacier sends a notification
	// when the job is completed and the output is ready for you to download. The
	// specified topic publishes the notification to its subscribers. The SNS topic
	// must exist.
	SNSTopic *string `type:"string"`

	// Contains the parameters that define a job.
	SelectParameters *SelectParameters `type:"structure"`

	// The tier to use for a select or an archive retrieval job. Valid values are
	// Expedited, Standard, or Bulk. Standard is the default.
	Tier *string `type:"string"`

	// The job type. You can initiate a job to perform a select query on an archive,
	// retrieve an archive, or get an inventory of a vault. Valid values are "select",
	// "archive-retrieval" and "inventory-retrieval".
	Type *string `type:"string"`
}

// String returns the string representation
func (s JobParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "JobParameters"}
	if s.OutputLocation != nil {
		if err := s.OutputLocation.Validate(); err != nil {
			invalidParams.AddNested("OutputLocation", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.ArchiveId != nil {
		v := *s.ArchiveId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ArchiveId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Format != nil {
		v := *s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Format", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InventoryRetrievalParameters != nil {
		v := s.InventoryRetrievalParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "InventoryRetrievalParameters", v, metadata)
	}
	if s.OutputLocation != nil {
		v := s.OutputLocation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "OutputLocation", v, metadata)
	}
	if s.RetrievalByteRange != nil {
		v := *s.RetrievalByteRange

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RetrievalByteRange", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SNSTopic != nil {
		v := *s.SNSTopic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SNSTopic", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SelectParameters != nil {
		v := s.SelectParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SelectParameters", v, metadata)
	}
	if s.Tier != nil {
		v := *s.Tier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Tier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the location where the select job results are
// stored.
type OutputLocation struct {
	_ struct{} `type:"structure"`

	// Describes an S3 location that will receive the results of the job request.
	S3 *S3Location `type:"structure"`
}

// String returns the string representation
func (s OutputLocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputLocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputLocation"}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutputLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3 != nil {
		v := s.S3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3", v, metadata)
	}
	return nil
}

// Describes how the select output is serialized.
type OutputSerialization struct {
	_ struct{} `type:"structure"`

	// Describes the serialization of CSV-encoded query results.
	Csv *CSVOutput `locationName:"csv" type:"structure"`
}

// String returns the string representation
func (s OutputSerialization) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutputSerialization) MarshalFields(e protocol.FieldEncoder) error {
	if s.Csv != nil {
		v := s.Csv

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "csv", v, metadata)
	}
	return nil
}

// A list of the part sizes of the multipart upload.
type PartListElement struct {
	_ struct{} `type:"structure"`

	// The byte range of a part, inclusive of the upper value of the range.
	RangeInBytes *string `type:"string"`

	// The SHA256 tree hash value that Amazon S3 Glacier calculated for the part.
	// This field is never null.
	SHA256TreeHash *string `type:"string"`
}

// String returns the string representation
func (s PartListElement) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PartListElement) MarshalFields(e protocol.FieldEncoder) error {
	if s.RangeInBytes != nil {
		v := *s.RangeInBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RangeInBytes", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SHA256TreeHash != nil {
		v := *s.SHA256TreeHash

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SHA256TreeHash", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The definition for a provisioned capacity unit.
type ProvisionedCapacityDescription struct {
	_ struct{} `type:"structure"`

	// The ID that identifies the provisioned capacity unit.
	CapacityId *string `type:"string"`

	// The date that the provisioned capacity unit expires, in Universal Coordinated
	// Time (UTC).
	ExpirationDate *string `type:"string"`

	// The date that the provisioned capacity unit was purchased, in Universal Coordinated
	// Time (UTC).
	StartDate *string `type:"string"`
}

// String returns the string representation
func (s ProvisionedCapacityDescription) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProvisionedCapacityDescription) MarshalFields(e protocol.FieldEncoder) error {
	if s.CapacityId != nil {
		v := *s.CapacityId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CapacityId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExpirationDate != nil {
		v := *s.ExpirationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExpirationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartDate != nil {
		v := *s.StartDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the location in Amazon S3 where the select job
// results are stored.
type S3Location struct {
	_ struct{} `type:"structure"`

	// A list of grants that control access to the staged results.
	AccessControlList []Grant `type:"list"`

	// The name of the Amazon S3 bucket where the job results are stored.
	BucketName *string `type:"string"`

	// The canned access control list (ACL) to apply to the job results.
	CannedACL CannedACL `type:"string" enum:"true"`

	// Contains information about the encryption used to store the job results in
	// Amazon S3.
	Encryption *Encryption `type:"structure"`

	// The prefix that is prepended to the results for this request.
	Prefix *string `type:"string"`

	// The storage class used to store the job results.
	StorageClass StorageClass `type:"string" enum:"true"`

	// The tag-set that is applied to the job results.
	Tagging map[string]string `type:"map"`

	// A map of metadata to store with the job results in Amazon S3.
	UserMetadata map[string]string `type:"map"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Location) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Location"}
	if s.AccessControlList != nil {
		for i, v := range s.AccessControlList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessControlList", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3Location) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessControlList != nil {
		v := s.AccessControlList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AccessControlList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.BucketName != nil {
		v := *s.BucketName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BucketName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.CannedACL) > 0 {
		v := s.CannedACL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CannedACL", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Encryption != nil {
		v := s.Encryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Encryption", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tagging != nil {
		v := s.Tagging

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Tagging", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.UserMetadata != nil {
		v := s.UserMetadata

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "UserMetadata", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Contains information about the parameters used for a select.
type SelectParameters struct {
	_ struct{} `type:"structure"`

	// The expression that is used to select the object.
	Expression *string `type:"string"`

	// The type of the provided expression, for example SQL.
	ExpressionType ExpressionType `type:"string" enum:"true"`

	// Describes the serialization format of the object.
	InputSerialization *InputSerialization `type:"structure"`

	// Describes how the results of the select job are serialized.
	OutputSerialization *OutputSerialization `type:"structure"`
}

// String returns the string representation
func (s SelectParameters) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SelectParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.Expression != nil {
		v := *s.Expression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Expression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ExpressionType) > 0 {
		v := s.ExpressionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExpressionType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.InputSerialization != nil {
		v := s.InputSerialization

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "InputSerialization", v, metadata)
	}
	if s.OutputSerialization != nil {
		v := s.OutputSerialization

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "OutputSerialization", v, metadata)
	}
	return nil
}

// A list of in-progress multipart uploads for a vault.
type UploadListElement struct {
	_ struct{} `type:"structure"`

	// The description of the archive that was specified in the Initiate Multipart
	// Upload request.
	ArchiveDescription *string `type:"string"`

	// The UTC time at which the multipart upload was initiated.
	CreationDate *string `type:"string"`

	// The ID of a multipart upload.
	MultipartUploadId *string `type:"string"`

	// The part size, in bytes, specified in the Initiate Multipart Upload request.
	// This is the size of all the parts in the upload except the last part, which
	// may be smaller than this size.
	PartSizeInBytes *int64 `type:"long"`

	// The Amazon Resource Name (ARN) of the vault that contains the archive.
	VaultARN *string `type:"string"`
}

// String returns the string representation
func (s UploadListElement) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UploadListElement) MarshalFields(e protocol.FieldEncoder) error {
	if s.ArchiveDescription != nil {
		v := *s.ArchiveDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ArchiveDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MultipartUploadId != nil {
		v := *s.MultipartUploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MultipartUploadId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PartSizeInBytes != nil {
		v := *s.PartSizeInBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PartSizeInBytes", protocol.Int64Value(v), metadata)
	}
	if s.VaultARN != nil {
		v := *s.VaultARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VaultARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains the vault access policy.
type VaultAccessPolicy struct {
	_ struct{} `type:"structure"`

	// The vault access policy.
	Policy *string `type:"string"`
}

// String returns the string representation
func (s VaultAccessPolicy) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VaultAccessPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.Policy != nil {
		v := *s.Policy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Policy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains the vault lock policy.
type VaultLockPolicy struct {
	_ struct{} `type:"structure"`

	// The vault lock policy.
	Policy *string `type:"string"`
}

// String returns the string representation
func (s VaultLockPolicy) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VaultLockPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.Policy != nil {
		v := *s.Policy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Policy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a vault's notification configuration.
type VaultNotificationConfig struct {
	_ struct{} `type:"structure"`

	// A list of one or more events for which Amazon S3 Glacier will send a notification
	// to the specified Amazon SNS topic.
	Events []string `type:"list"`

	// The Amazon Simple Notification Service (Amazon SNS) topic Amazon Resource
	// Name (ARN).
	SNSTopic *string `type:"string"`
}

// String returns the string representation
func (s VaultNotificationConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VaultNotificationConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Events != nil {
		v := s.Events

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Events", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SNSTopic != nil {
		v := *s.SNSTopic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SNSTopic", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
