// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type RemoveRoleFromInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance profile to update.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// InstanceProfileName is a required field
	InstanceProfileName *string `min:"1" type:"string" required:"true"`

	// The name of the role to remove.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveRoleFromInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveRoleFromInstanceProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RemoveRoleFromInstanceProfileInput"}

	if s.InstanceProfileName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceProfileName"))
	}
	if s.InstanceProfileName != nil && len(*s.InstanceProfileName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceProfileName", 1))
	}

	if s.RoleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RemoveRoleFromInstanceProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveRoleFromInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

const opRemoveRoleFromInstanceProfile = "RemoveRoleFromInstanceProfile"

// RemoveRoleFromInstanceProfileRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Removes the specified IAM role from the specified EC2 instance profile.
//
// Make sure that you do not have any Amazon EC2 instances running with the
// role you are about to remove from the instance profile. Removing a role from
// an instance profile that is associated with a running instance might break
// any applications running on the instance.
//
// For more information about IAM roles, go to Working with Roles (https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html).
// For more information about instance profiles, go to About Instance Profiles
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
//
//    // Example sending a request using RemoveRoleFromInstanceProfileRequest.
//    req := client.RemoveRoleFromInstanceProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveRoleFromInstanceProfile
func (c *Client) RemoveRoleFromInstanceProfileRequest(input *RemoveRoleFromInstanceProfileInput) RemoveRoleFromInstanceProfileRequest {
	op := &aws.Operation{
		Name:       opRemoveRoleFromInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveRoleFromInstanceProfileInput{}
	}

	req := c.newRequest(op, input, &RemoveRoleFromInstanceProfileOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return RemoveRoleFromInstanceProfileRequest{Request: req, Input: input, Copy: c.RemoveRoleFromInstanceProfileRequest}
}

// RemoveRoleFromInstanceProfileRequest is the request type for the
// RemoveRoleFromInstanceProfile API operation.
type RemoveRoleFromInstanceProfileRequest struct {
	*aws.Request
	Input *RemoveRoleFromInstanceProfileInput
	Copy  func(*RemoveRoleFromInstanceProfileInput) RemoveRoleFromInstanceProfileRequest
}

// Send marshals and sends the RemoveRoleFromInstanceProfile API request.
func (r RemoveRoleFromInstanceProfileRequest) Send(ctx context.Context) (*RemoveRoleFromInstanceProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RemoveRoleFromInstanceProfileResponse{
		RemoveRoleFromInstanceProfileOutput: r.Request.Data.(*RemoveRoleFromInstanceProfileOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RemoveRoleFromInstanceProfileResponse is the response type for the
// RemoveRoleFromInstanceProfile API operation.
type RemoveRoleFromInstanceProfileResponse struct {
	*RemoveRoleFromInstanceProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RemoveRoleFromInstanceProfile request.
func (r *RemoveRoleFromInstanceProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
