// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package inspector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeAssessmentTemplatesInput struct {
	_ struct{} `type:"structure"`

	// AssessmentTemplateArns is a required field
	AssessmentTemplateArns []string `locationName:"assessmentTemplateArns" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeAssessmentTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAssessmentTemplatesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAssessmentTemplatesInput"}

	if s.AssessmentTemplateArns == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssessmentTemplateArns"))
	}
	if s.AssessmentTemplateArns != nil && len(s.AssessmentTemplateArns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssessmentTemplateArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAssessmentTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the assessment templates.
	//
	// AssessmentTemplates is a required field
	AssessmentTemplates []AssessmentTemplate `locationName:"assessmentTemplates" type:"list" required:"true"`

	// Assessment template details that cannot be described. An error code is provided
	// for each failed item.
	//
	// FailedItems is a required field
	FailedItems map[string]FailedItemDetails `locationName:"failedItems" type:"map" required:"true"`
}

// String returns the string representation
func (s DescribeAssessmentTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAssessmentTemplates = "DescribeAssessmentTemplates"

// DescribeAssessmentTemplatesRequest returns a request value for making API operation for
// Amazon Inspector.
//
// Describes the assessment templates that are specified by the ARNs of the
// assessment templates.
//
//    // Example sending a request using DescribeAssessmentTemplatesRequest.
//    req := client.DescribeAssessmentTemplatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentTemplates
func (c *Client) DescribeAssessmentTemplatesRequest(input *DescribeAssessmentTemplatesInput) DescribeAssessmentTemplatesRequest {
	op := &aws.Operation{
		Name:       opDescribeAssessmentTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAssessmentTemplatesInput{}
	}

	req := c.newRequest(op, input, &DescribeAssessmentTemplatesOutput{})
	return DescribeAssessmentTemplatesRequest{Request: req, Input: input, Copy: c.DescribeAssessmentTemplatesRequest}
}

// DescribeAssessmentTemplatesRequest is the request type for the
// DescribeAssessmentTemplates API operation.
type DescribeAssessmentTemplatesRequest struct {
	*aws.Request
	Input *DescribeAssessmentTemplatesInput
	Copy  func(*DescribeAssessmentTemplatesInput) DescribeAssessmentTemplatesRequest
}

// Send marshals and sends the DescribeAssessmentTemplates API request.
func (r DescribeAssessmentTemplatesRequest) Send(ctx context.Context) (*DescribeAssessmentTemplatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAssessmentTemplatesResponse{
		DescribeAssessmentTemplatesOutput: r.Request.Data.(*DescribeAssessmentTemplatesOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAssessmentTemplatesResponse is the response type for the
// DescribeAssessmentTemplates API operation.
type DescribeAssessmentTemplatesResponse struct {
	*DescribeAssessmentTemplatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAssessmentTemplates request.
func (r *DescribeAssessmentTemplatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
