// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kendra

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListIndicesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of data sources to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Kendra returns a pagination token in the response. You can use this
	// pagination token to retrieve the next set of indexes (DataSourceSummaryItems).
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIndicesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIndicesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListIndicesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListIndicesOutput struct {
	_ struct{} `type:"structure"`

	// An array of summary information for one or more indexes.
	IndexConfigurationSummaryItems []IndexConfigurationSummary `type:"list"`

	// If the response is truncated, Amazon Kendra returns this token that you can
	// use in the subsequent request to retrieve the next set of indexes.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIndicesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListIndices = "ListIndices"

// ListIndicesRequest returns a request value for making API operation for
// AWSKendraFrontendService.
//
// Lists the Amazon Kendra indexes that you have created.
//
//    // Example sending a request using ListIndicesRequest.
//    req := client.ListIndicesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ListIndices
func (c *Client) ListIndicesRequest(input *ListIndicesInput) ListIndicesRequest {
	op := &aws.Operation{
		Name:       opListIndices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIndicesInput{}
	}

	req := c.newRequest(op, input, &ListIndicesOutput{})
	return ListIndicesRequest{Request: req, Input: input, Copy: c.ListIndicesRequest}
}

// ListIndicesRequest is the request type for the
// ListIndices API operation.
type ListIndicesRequest struct {
	*aws.Request
	Input *ListIndicesInput
	Copy  func(*ListIndicesInput) ListIndicesRequest
}

// Send marshals and sends the ListIndices API request.
func (r ListIndicesRequest) Send(ctx context.Context) (*ListIndicesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListIndicesResponse{
		ListIndicesOutput: r.Request.Data.(*ListIndicesOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListIndicesRequestPaginator returns a paginator for ListIndices.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListIndicesRequest(input)
//   p := kendra.NewListIndicesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListIndicesPaginator(req ListIndicesRequest) ListIndicesPaginator {
	return ListIndicesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListIndicesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListIndicesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListIndicesPaginator struct {
	aws.Pager
}

func (p *ListIndicesPaginator) CurrentPage() *ListIndicesOutput {
	return p.Pager.CurrentPage().(*ListIndicesOutput)
}

// ListIndicesResponse is the response type for the
// ListIndices API operation.
type ListIndicesResponse struct {
	*ListIndicesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListIndices request.
func (r *ListIndicesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
