// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type AuthorizeClusterSecurityGroupIngressInput struct {
	_ struct{} `type:"structure"`

	// The IP range to be added the Amazon Redshift security group.
	CIDRIP *string `type:"string"`

	// The name of the security group to which the ingress rule is added.
	//
	// ClusterSecurityGroupName is a required field
	ClusterSecurityGroupName *string `type:"string" required:"true"`

	// The EC2 security group to be added the Amazon Redshift security group.
	EC2SecurityGroupName *string `type:"string"`

	// The AWS account number of the owner of the security group specified by the
	// EC2SecurityGroupName parameter. The AWS Access Key ID is not an acceptable
	// value.
	//
	// Example: 111122223333
	EC2SecurityGroupOwnerId *string `type:"string"`
}

// String returns the string representation
func (s AuthorizeClusterSecurityGroupIngressInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizeClusterSecurityGroupIngressInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AuthorizeClusterSecurityGroupIngressInput"}

	if s.ClusterSecurityGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterSecurityGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AuthorizeClusterSecurityGroupIngressOutput struct {
	_ struct{} `type:"structure"`

	// Describes a security group.
	ClusterSecurityGroup *ClusterSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s AuthorizeClusterSecurityGroupIngressOutput) String() string {
	return awsutil.Prettify(s)
}

const opAuthorizeClusterSecurityGroupIngress = "AuthorizeClusterSecurityGroupIngress"

// AuthorizeClusterSecurityGroupIngressRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending
// on whether the application accessing your cluster is running on the Internet
// or an Amazon EC2 instance, you can authorize inbound access to either a Classless
// Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2
// security group. You can add as many as 20 ingress rules to an Amazon Redshift
// security group.
//
// If you authorize access to an Amazon EC2 security group, specify EC2SecurityGroupName
// and EC2SecurityGroupOwnerId. The Amazon EC2 security group and Amazon Redshift
// cluster must be in the same AWS Region.
//
// If you authorize access to a CIDR/IP address range, specify CIDRIP. For an
// overview of CIDR blocks, see the Wikipedia article on Classless Inter-Domain
// Routing (http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
//
// You must also associate the security group with a cluster so that clients
// running on these IP addresses or the EC2 instance are authorized to connect
// to the cluster. For information about managing security groups, go to Working
// with Security Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
//    // Example sending a request using AuthorizeClusterSecurityGroupIngressRequest.
//    req := client.AuthorizeClusterSecurityGroupIngressRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeClusterSecurityGroupIngress
func (c *Client) AuthorizeClusterSecurityGroupIngressRequest(input *AuthorizeClusterSecurityGroupIngressInput) AuthorizeClusterSecurityGroupIngressRequest {
	op := &aws.Operation{
		Name:       opAuthorizeClusterSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeClusterSecurityGroupIngressInput{}
	}

	req := c.newRequest(op, input, &AuthorizeClusterSecurityGroupIngressOutput{})
	return AuthorizeClusterSecurityGroupIngressRequest{Request: req, Input: input, Copy: c.AuthorizeClusterSecurityGroupIngressRequest}
}

// AuthorizeClusterSecurityGroupIngressRequest is the request type for the
// AuthorizeClusterSecurityGroupIngress API operation.
type AuthorizeClusterSecurityGroupIngressRequest struct {
	*aws.Request
	Input *AuthorizeClusterSecurityGroupIngressInput
	Copy  func(*AuthorizeClusterSecurityGroupIngressInput) AuthorizeClusterSecurityGroupIngressRequest
}

// Send marshals and sends the AuthorizeClusterSecurityGroupIngress API request.
func (r AuthorizeClusterSecurityGroupIngressRequest) Send(ctx context.Context) (*AuthorizeClusterSecurityGroupIngressResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AuthorizeClusterSecurityGroupIngressResponse{
		AuthorizeClusterSecurityGroupIngressOutput: r.Request.Data.(*AuthorizeClusterSecurityGroupIngressOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AuthorizeClusterSecurityGroupIngressResponse is the response type for the
// AuthorizeClusterSecurityGroupIngress API operation.
type AuthorizeClusterSecurityGroupIngressResponse struct {
	*AuthorizeClusterSecurityGroupIngressOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AuthorizeClusterSecurityGroupIngress request.
func (r *AuthorizeClusterSecurityGroupIngressResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
