// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53resolver

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListResolverRuleAssociationsInput struct {
	_ struct{} `type:"structure"`

	// An optional specification to return a subset of resolver rules, such as resolver
	// rules that are associated with the same VPC ID.
	//
	// If you submit a second or subsequent ListResolverRuleAssociations request
	// and specify the NextToken parameter, you must use the same values for Filters,
	// if any, as in the previous request.
	Filters []Filter `type:"list"`

	// The maximum number of rule associations that you want to return in the response
	// to a ListResolverRuleAssociations request. If you don't specify a value for
	// MaxResults, Resolver returns up to 100 rule associations.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListResolverRuleAssociation request, omit this value.
	//
	// If you have more than MaxResults rule associations, you can submit another
	// ListResolverRuleAssociation request to get the next group of rule associations.
	// In the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListResolverRuleAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolverRuleAssociationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListResolverRuleAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListResolverRuleAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The value that you specified for MaxResults in the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// If more than MaxResults rule associations match the specified criteria, you
	// can submit another ListResolverRuleAssociation request to get the next group
	// of results. In the next request, specify the value of NextToken from the
	// previous response.
	NextToken *string `type:"string"`

	// The associations that were created between resolver rules and VPCs using
	// the current AWS account, and that match the specified filters, if any.
	ResolverRuleAssociations []ResolverRuleAssociation `type:"list"`
}

// String returns the string representation
func (s ListResolverRuleAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListResolverRuleAssociations = "ListResolverRuleAssociations"

// ListResolverRuleAssociationsRequest returns a request value for making API operation for
// Amazon Route 53 Resolver.
//
// Lists the associations that were created between resolver rules and VPCs
// using the current AWS account.
//
//    // Example sending a request using ListResolverRuleAssociationsRequest.
//    req := client.ListResolverRuleAssociationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations
func (c *Client) ListResolverRuleAssociationsRequest(input *ListResolverRuleAssociationsInput) ListResolverRuleAssociationsRequest {
	op := &aws.Operation{
		Name:       opListResolverRuleAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResolverRuleAssociationsInput{}
	}

	req := c.newRequest(op, input, &ListResolverRuleAssociationsOutput{})
	return ListResolverRuleAssociationsRequest{Request: req, Input: input, Copy: c.ListResolverRuleAssociationsRequest}
}

// ListResolverRuleAssociationsRequest is the request type for the
// ListResolverRuleAssociations API operation.
type ListResolverRuleAssociationsRequest struct {
	*aws.Request
	Input *ListResolverRuleAssociationsInput
	Copy  func(*ListResolverRuleAssociationsInput) ListResolverRuleAssociationsRequest
}

// Send marshals and sends the ListResolverRuleAssociations API request.
func (r ListResolverRuleAssociationsRequest) Send(ctx context.Context) (*ListResolverRuleAssociationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListResolverRuleAssociationsResponse{
		ListResolverRuleAssociationsOutput: r.Request.Data.(*ListResolverRuleAssociationsOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListResolverRuleAssociationsRequestPaginator returns a paginator for ListResolverRuleAssociations.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListResolverRuleAssociationsRequest(input)
//   p := route53resolver.NewListResolverRuleAssociationsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListResolverRuleAssociationsPaginator(req ListResolverRuleAssociationsRequest) ListResolverRuleAssociationsPaginator {
	return ListResolverRuleAssociationsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListResolverRuleAssociationsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListResolverRuleAssociationsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListResolverRuleAssociationsPaginator struct {
	aws.Pager
}

func (p *ListResolverRuleAssociationsPaginator) CurrentPage() *ListResolverRuleAssociationsOutput {
	return p.Pager.CurrentPage().(*ListResolverRuleAssociationsOutput)
}

// ListResolverRuleAssociationsResponse is the response type for the
// ListResolverRuleAssociations API operation.
type ListResolverRuleAssociationsResponse struct {
	*ListResolverRuleAssociationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListResolverRuleAssociations request.
func (r *ListResolverRuleAssociationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
