// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

type PutBucketLifecycleInput struct {
	_ struct{} `type:"structure" payload:"LifecycleConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Container for lifecycle rules. You can add as many as 1000 rules.
	LifecycleConfiguration *LifecycleConfiguration `locationName:"LifecycleConfiguration" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketLifecycleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketLifecycleInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if s.LifecycleConfiguration != nil {
		if err := s.LifecycleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LifecycleConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketLifecycleInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketLifecycleInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.LifecycleConfiguration != nil {
		v := s.LifecycleConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "LifecycleConfiguration", v, metadata)
	}
	return nil
}

type PutBucketLifecycleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketLifecycleOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutBucketLifecycle = "PutBucketLifecycle"

// PutBucketLifecycleRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
//
// For an updated version of this API, see PutBucketLifecycleConfiguration.
// This version has been deprecated. Existing lifecycle configurations will
// work. For new lifecycle configurations, use the updated API.
//
// Creates a new lifecycle configuration for the bucket or replaces an existing
// lifecycle configuration. For information about lifecycle configuration, see
// Object Lifecycle Management (https://docs.aws.amazon.com/AmazonS3/latest/dev//object-lifecycle-mgmt.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// By default, all Amazon S3 resources, including buckets, objects, and related
// subresources (for example, lifecycle configuration and website configuration)
// are private. Only the resource owner, the AWS account that created the resource,
// can access it. The resource owner can optionally grant access permissions
// to others by writing an access policy. For this operation, users must get
// the s3:PutLifecycleConfiguration permission.
//
// You can also explicitly deny permissions. Explicit denial also supersedes
// any other permissions. If you want to prevent users or accounts from removing
// or deleting objects from your bucket, you must deny them permissions for
// the following actions:
//
//    * s3:DeleteObject
//
//    * s3:DeleteObjectVersion
//
//    * s3:PutLifecycleConfiguration
//
// For more information about permissions, see Managing Access Permissions to
// your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/dev//s3-access-control.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// For more examples of transitioning objects to storage classes such as STANDARD_IA
// or ONEZONE_IA, see Examples of Lifecycle Configuration (https://docs.aws.amazon.com/AmazonS3/latest/dev//intro-lifecycle-rules.html#lifecycle-configuration-examples).
//
// Related Resources
//
//    * GetBucketLifecycle(Deprecated)
//
//    * GetBucketLifecycleConfiguration
//
//    *
//
//    * By default, a resource owner—in this case, a bucket owner, which is
//    the AWS account that created the bucket—can perform any of the operations.
//    A resource owner can also grant others permission to perform the operation.
//    For more information, see the following topics in the Amazon Simple Storage
//    Service Developer Guide: Specifying Permissions in a Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev//using-with-s3-actions.html)
//    Managing Access Permissions to your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/dev//s3-access-control.html)
//
//    // Example sending a request using PutBucketLifecycleRequest.
//    req := client.PutBucketLifecycleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycle
func (c *Client) PutBucketLifecycleRequest(input *PutBucketLifecycleInput) PutBucketLifecycleRequest {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, PutBucketLifecycle, has been deprecated")
	}
	op := &aws.Operation{
		Name:       opPutBucketLifecycle,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &PutBucketLifecycleInput{}
	}

	req := c.newRequest(op, input, &PutBucketLifecycleOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutBucketLifecycleRequest{Request: req, Input: input, Copy: c.PutBucketLifecycleRequest}
}

// PutBucketLifecycleRequest is the request type for the
// PutBucketLifecycle API operation.
type PutBucketLifecycleRequest struct {
	*aws.Request
	Input *PutBucketLifecycleInput
	Copy  func(*PutBucketLifecycleInput) PutBucketLifecycleRequest
}

// Send marshals and sends the PutBucketLifecycle API request.
func (r PutBucketLifecycleRequest) Send(ctx context.Context) (*PutBucketLifecycleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutBucketLifecycleResponse{
		PutBucketLifecycleOutput: r.Request.Data.(*PutBucketLifecycleOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutBucketLifecycleResponse is the response type for the
// PutBucketLifecycle API operation.
type PutBucketLifecycleResponse struct {
	*PutBucketLifecycleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutBucketLifecycle request.
func (r *PutBucketLifecycleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
