// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package schemas

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateSchemaInput struct {
	_ struct{} `type:"structure"`

	ClientTokenId *string `type:"string" idempotencyToken:"true"`

	Content *string `min:"1" type:"string"`

	Description *string `type:"string"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`

	// SchemaName is a required field
	SchemaName *string `location:"uri" locationName:"schemaName" type:"string" required:"true"`

	Type Type `type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdateSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSchemaInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateSchemaInput"}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Content", 1))
	}

	if s.RegistryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RegistryName"))
	}

	if s.SchemaName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SchemaName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateSchemaInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientTokenId string
	if s.ClientTokenId != nil {
		ClientTokenId = *s.ClientTokenId
	} else {
		ClientTokenId = protocol.GetIdempotencyToken()
	}
	{
		v := ClientTokenId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientTokenId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Content != nil {
		v := *s.Content

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Content", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RegistryName != nil {
		v := *s.RegistryName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "registryName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SchemaName != nil {
		v := *s.SchemaName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "schemaName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateSchemaOutput struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	SchemaArn *string `type:"string"`

	SchemaName *string `type:"string"`

	SchemaVersion *string `type:"string"`

	// Key-value pairs associated with a resource.
	Tags map[string]string `locationName:"tags" type:"map"`

	Type *string `type:"string"`

	VersionCreatedDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s UpdateSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateSchemaOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.SchemaArn != nil {
		v := *s.SchemaArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SchemaArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SchemaName != nil {
		v := *s.SchemaName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SchemaName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SchemaVersion != nil {
		v := *s.SchemaVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SchemaVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionCreatedDate != nil {
		v := *s.VersionCreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionCreatedDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

const opUpdateSchema = "UpdateSchema"

// UpdateSchemaRequest returns a request value for making API operation for
// Schemas.
//
// Updates the schema definition
//
//    // Example sending a request using UpdateSchemaRequest.
//    req := client.UpdateSchemaRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateSchema
func (c *Client) UpdateSchemaRequest(input *UpdateSchemaInput) UpdateSchemaRequest {
	op := &aws.Operation{
		Name:       opUpdateSchema,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/registries/name/{registryName}/schemas/name/{schemaName}",
	}

	if input == nil {
		input = &UpdateSchemaInput{}
	}

	req := c.newRequest(op, input, &UpdateSchemaOutput{})
	return UpdateSchemaRequest{Request: req, Input: input, Copy: c.UpdateSchemaRequest}
}

// UpdateSchemaRequest is the request type for the
// UpdateSchema API operation.
type UpdateSchemaRequest struct {
	*aws.Request
	Input *UpdateSchemaInput
	Copy  func(*UpdateSchemaInput) UpdateSchemaRequest
}

// Send marshals and sends the UpdateSchema API request.
func (r UpdateSchemaRequest) Send(ctx context.Context) (*UpdateSchemaResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateSchemaResponse{
		UpdateSchemaOutput: r.Request.Data.(*UpdateSchemaOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateSchemaResponse is the response type for the
// UpdateSchema API operation.
type UpdateSchemaResponse struct {
	*UpdateSchemaOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateSchema request.
func (r *UpdateSchemaResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
