// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeWorkspaceDirectoriesInput struct {
	_ struct{} `type:"structure"`

	// The identifiers of the directories. If the value is null, all directories
	// are retrieved.
	DirectoryIds []string `min:"1" type:"list"`

	// The maximum number of directories to return.
	Limit *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeWorkspaceDirectoriesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceDirectoriesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeWorkspaceDirectoriesInput"}
	if s.DirectoryIds != nil && len(s.DirectoryIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DirectoryIds", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeWorkspaceDirectoriesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the directories.
	Directories []WorkspaceDirectory `type:"list"`

	// The token to use to retrieve the next set of results, or null if no more
	// results are available.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeWorkspaceDirectoriesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeWorkspaceDirectories = "DescribeWorkspaceDirectories"

// DescribeWorkspaceDirectoriesRequest returns a request value for making API operation for
// Amazon WorkSpaces.
//
// Describes the available directories that are registered with Amazon WorkSpaces.
//
//    // Example sending a request using DescribeWorkspaceDirectoriesRequest.
//    req := client.DescribeWorkspaceDirectoriesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories
func (c *Client) DescribeWorkspaceDirectoriesRequest(input *DescribeWorkspaceDirectoriesInput) DescribeWorkspaceDirectoriesRequest {
	op := &aws.Operation{
		Name:       opDescribeWorkspaceDirectories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeWorkspaceDirectoriesInput{}
	}

	req := c.newRequest(op, input, &DescribeWorkspaceDirectoriesOutput{})
	return DescribeWorkspaceDirectoriesRequest{Request: req, Input: input, Copy: c.DescribeWorkspaceDirectoriesRequest}
}

// DescribeWorkspaceDirectoriesRequest is the request type for the
// DescribeWorkspaceDirectories API operation.
type DescribeWorkspaceDirectoriesRequest struct {
	*aws.Request
	Input *DescribeWorkspaceDirectoriesInput
	Copy  func(*DescribeWorkspaceDirectoriesInput) DescribeWorkspaceDirectoriesRequest
}

// Send marshals and sends the DescribeWorkspaceDirectories API request.
func (r DescribeWorkspaceDirectoriesRequest) Send(ctx context.Context) (*DescribeWorkspaceDirectoriesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeWorkspaceDirectoriesResponse{
		DescribeWorkspaceDirectoriesOutput: r.Request.Data.(*DescribeWorkspaceDirectoriesOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeWorkspaceDirectoriesRequestPaginator returns a paginator for DescribeWorkspaceDirectories.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeWorkspaceDirectoriesRequest(input)
//   p := workspaces.NewDescribeWorkspaceDirectoriesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeWorkspaceDirectoriesPaginator(req DescribeWorkspaceDirectoriesRequest) DescribeWorkspaceDirectoriesPaginator {
	return DescribeWorkspaceDirectoriesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeWorkspaceDirectoriesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeWorkspaceDirectoriesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeWorkspaceDirectoriesPaginator struct {
	aws.Pager
}

func (p *DescribeWorkspaceDirectoriesPaginator) CurrentPage() *DescribeWorkspaceDirectoriesOutput {
	return p.Pager.CurrentPage().(*DescribeWorkspaceDirectoriesOutput)
}

// DescribeWorkspaceDirectoriesResponse is the response type for the
// DescribeWorkspaceDirectories API operation.
type DescribeWorkspaceDirectoriesResponse struct {
	*DescribeWorkspaceDirectoriesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeWorkspaceDirectories request.
func (r *DescribeWorkspaceDirectoriesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
