// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ApproveSkillRequest
type ApproveSkillInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the skill.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ApproveSkillInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApproveSkillInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ApproveSkillInput"}

	if s.SkillId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SkillId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ApproveSkillResponse
type ApproveSkillOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ApproveSkillOutput) String() string {
	return awsutil.Prettify(s)
}

const opApproveSkill = "ApproveSkill"

// ApproveSkillRequest returns a request value for making API operation for
// Alexa For Business.
//
// Associates a skill with the organization under the customer's AWS account.
// If a skill is private, the user implicitly accepts access to this skill during
// enablement.
//
//    // Example sending a request using ApproveSkillRequest.
//    req := client.ApproveSkillRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ApproveSkill
func (c *Client) ApproveSkillRequest(input *ApproveSkillInput) ApproveSkillRequest {
	op := &aws.Operation{
		Name:       opApproveSkill,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ApproveSkillInput{}
	}

	req := c.newRequest(op, input, &ApproveSkillOutput{})
	return ApproveSkillRequest{Request: req, Input: input, Copy: c.ApproveSkillRequest}
}

// ApproveSkillRequest is the request type for the
// ApproveSkill API operation.
type ApproveSkillRequest struct {
	*aws.Request
	Input *ApproveSkillInput
	Copy  func(*ApproveSkillInput) ApproveSkillRequest
}

// Send marshals and sends the ApproveSkill API request.
func (r ApproveSkillRequest) Send(ctx context.Context) (*ApproveSkillResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ApproveSkillResponse{
		ApproveSkillOutput: r.Request.Data.(*ApproveSkillOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ApproveSkillResponse is the response type for the
// ApproveSkill API operation.
type ApproveSkillResponse struct {
	*ApproveSkillOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ApproveSkill request.
func (r *ApproveSkillResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
