// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillAuthorizationRequest
type DeleteSkillAuthorizationInput struct {
	_ struct{} `type:"structure"`

	// The room that the skill is authorized for.
	RoomArn *string `type:"string"`

	// The unique identifier of a skill.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSkillAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSkillAuthorizationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteSkillAuthorizationInput"}

	if s.SkillId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SkillId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillAuthorizationResponse
type DeleteSkillAuthorizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSkillAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteSkillAuthorization = "DeleteSkillAuthorization"

// DeleteSkillAuthorizationRequest returns a request value for making API operation for
// Alexa For Business.
//
// Unlinks a third-party account from a skill.
//
//    // Example sending a request using DeleteSkillAuthorizationRequest.
//    req := client.DeleteSkillAuthorizationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillAuthorization
func (c *Client) DeleteSkillAuthorizationRequest(input *DeleteSkillAuthorizationInput) DeleteSkillAuthorizationRequest {
	op := &aws.Operation{
		Name:       opDeleteSkillAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSkillAuthorizationInput{}
	}

	req := c.newRequest(op, input, &DeleteSkillAuthorizationOutput{})
	return DeleteSkillAuthorizationRequest{Request: req, Input: input, Copy: c.DeleteSkillAuthorizationRequest}
}

// DeleteSkillAuthorizationRequest is the request type for the
// DeleteSkillAuthorization API operation.
type DeleteSkillAuthorizationRequest struct {
	*aws.Request
	Input *DeleteSkillAuthorizationInput
	Copy  func(*DeleteSkillAuthorizationInput) DeleteSkillAuthorizationRequest
}

// Send marshals and sends the DeleteSkillAuthorization API request.
func (r DeleteSkillAuthorizationRequest) Send(ctx context.Context) (*DeleteSkillAuthorizationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSkillAuthorizationResponse{
		DeleteSkillAuthorizationOutput: r.Request.Data.(*DeleteSkillAuthorizationOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSkillAuthorizationResponse is the response type for the
// DeleteSkillAuthorization API operation.
type DeleteSkillAuthorizationResponse struct {
	*DeleteSkillAuthorizationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSkillAuthorization request.
func (r *DeleteSkillAuthorizationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
