// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGatewaysRequest
type ListGatewaysInput struct {
	_ struct{} `type:"structure"`

	// The gateway group ARN for which to list gateways.
	GatewayGroupArn *string `type:"string"`

	// The maximum number of gateway summaries to return. The default is 50.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token used to paginate though multiple pages of gateway summaries.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGatewaysInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListGatewaysInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGatewaysResponse
type ListGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// The gateways in the list.
	Gateways []GatewaySummary `type:"list"`

	// The token used to paginate though multiple pages of gateway summaries.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

const opListGateways = "ListGateways"

// ListGatewaysRequest returns a request value for making API operation for
// Alexa For Business.
//
// Retrieves a list of gateway summaries. Use GetGateway to retrieve details
// of a specific gateway. An optional gateway group ARN can be provided to only
// retrieve gateway summaries of gateways that are associated with that gateway
// group ARN.
//
//    // Example sending a request using ListGatewaysRequest.
//    req := client.ListGatewaysRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGateways
func (c *Client) ListGatewaysRequest(input *ListGatewaysInput) ListGatewaysRequest {
	op := &aws.Operation{
		Name:       opListGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGatewaysInput{}
	}

	req := c.newRequest(op, input, &ListGatewaysOutput{})
	return ListGatewaysRequest{Request: req, Input: input, Copy: c.ListGatewaysRequest}
}

// ListGatewaysRequest is the request type for the
// ListGateways API operation.
type ListGatewaysRequest struct {
	*aws.Request
	Input *ListGatewaysInput
	Copy  func(*ListGatewaysInput) ListGatewaysRequest
}

// Send marshals and sends the ListGateways API request.
func (r ListGatewaysRequest) Send(ctx context.Context) (*ListGatewaysResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListGatewaysResponse{
		ListGatewaysOutput: r.Request.Data.(*ListGatewaysOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListGatewaysRequestPaginator returns a paginator for ListGateways.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListGatewaysRequest(input)
//   p := alexaforbusiness.NewListGatewaysRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListGatewaysPaginator(req ListGatewaysRequest) ListGatewaysPaginator {
	return ListGatewaysPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListGatewaysInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListGatewaysPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListGatewaysPaginator struct {
	aws.Pager
}

func (p *ListGatewaysPaginator) CurrentPage() *ListGatewaysOutput {
	return p.Pager.CurrentPage().(*ListGatewaysOutput)
}

// ListGatewaysResponse is the response type for the
// ListGateways API operation.
type ListGatewaysResponse struct {
	*ListGatewaysOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListGateways request.
func (r *ListGatewaysResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
