// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreSkillsByCategoryRequest
type ListSkillsStoreSkillsByCategoryInput struct {
	_ struct{} `type:"structure"`

	// The category ID for which the skills are being retrieved from the skill store.
	//
	// CategoryId is a required field
	CategoryId *int64 `min:"1" type:"long" required:"true"`

	// The maximum number of skills returned per paginated calls.
	MaxResults *int64 `min:"1" type:"integer"`

	// The tokens used for pagination.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSkillsStoreSkillsByCategoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSkillsStoreSkillsByCategoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListSkillsStoreSkillsByCategoryInput"}

	if s.CategoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CategoryId"))
	}
	if s.CategoryId != nil && *s.CategoryId < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("CategoryId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreSkillsByCategoryResponse
type ListSkillsStoreSkillsByCategoryOutput struct {
	_ struct{} `type:"structure"`

	// The tokens used for pagination.
	NextToken *string `min:"1" type:"string"`

	// The skill store skills.
	SkillsStoreSkills []SkillsStoreSkill `type:"list"`
}

// String returns the string representation
func (s ListSkillsStoreSkillsByCategoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opListSkillsStoreSkillsByCategory = "ListSkillsStoreSkillsByCategory"

// ListSkillsStoreSkillsByCategoryRequest returns a request value for making API operation for
// Alexa For Business.
//
// Lists all skills in the Alexa skill store by category.
//
//    // Example sending a request using ListSkillsStoreSkillsByCategoryRequest.
//    req := client.ListSkillsStoreSkillsByCategoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreSkillsByCategory
func (c *Client) ListSkillsStoreSkillsByCategoryRequest(input *ListSkillsStoreSkillsByCategoryInput) ListSkillsStoreSkillsByCategoryRequest {
	op := &aws.Operation{
		Name:       opListSkillsStoreSkillsByCategory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSkillsStoreSkillsByCategoryInput{}
	}

	req := c.newRequest(op, input, &ListSkillsStoreSkillsByCategoryOutput{})
	return ListSkillsStoreSkillsByCategoryRequest{Request: req, Input: input, Copy: c.ListSkillsStoreSkillsByCategoryRequest}
}

// ListSkillsStoreSkillsByCategoryRequest is the request type for the
// ListSkillsStoreSkillsByCategory API operation.
type ListSkillsStoreSkillsByCategoryRequest struct {
	*aws.Request
	Input *ListSkillsStoreSkillsByCategoryInput
	Copy  func(*ListSkillsStoreSkillsByCategoryInput) ListSkillsStoreSkillsByCategoryRequest
}

// Send marshals and sends the ListSkillsStoreSkillsByCategory API request.
func (r ListSkillsStoreSkillsByCategoryRequest) Send(ctx context.Context) (*ListSkillsStoreSkillsByCategoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSkillsStoreSkillsByCategoryResponse{
		ListSkillsStoreSkillsByCategoryOutput: r.Request.Data.(*ListSkillsStoreSkillsByCategoryOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListSkillsStoreSkillsByCategoryRequestPaginator returns a paginator for ListSkillsStoreSkillsByCategory.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListSkillsStoreSkillsByCategoryRequest(input)
//   p := alexaforbusiness.NewListSkillsStoreSkillsByCategoryRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListSkillsStoreSkillsByCategoryPaginator(req ListSkillsStoreSkillsByCategoryRequest) ListSkillsStoreSkillsByCategoryPaginator {
	return ListSkillsStoreSkillsByCategoryPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListSkillsStoreSkillsByCategoryInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListSkillsStoreSkillsByCategoryPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListSkillsStoreSkillsByCategoryPaginator struct {
	aws.Pager
}

func (p *ListSkillsStoreSkillsByCategoryPaginator) CurrentPage() *ListSkillsStoreSkillsByCategoryOutput {
	return p.Pager.CurrentPage().(*ListSkillsStoreSkillsByCategoryOutput)
}

// ListSkillsStoreSkillsByCategoryResponse is the response type for the
// ListSkillsStoreSkillsByCategory API operation.
type ListSkillsStoreSkillsByCategoryResponse struct {
	*ListSkillsStoreSkillsByCategoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSkillsStoreSkillsByCategory request.
func (r *ListSkillsStoreSkillsByCategoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
