// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchContactsRequest
type SearchContactsInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to list a specified set of address books. The supported
	// filter keys are DisplayName, FirstName, LastName, and AddressBookArns.
	Filters []Filter `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// only includes results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// The sort order to use in listing the specified set of contacts. The supported
	// sort keys are DisplayName, FirstName, and LastName.
	SortCriteria []Sort `type:"list"`
}

// String returns the string representation
func (s SearchContactsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchContactsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SearchContactsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SortCriteria != nil {
		for i, v := range s.SortCriteria {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortCriteria", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchContactsResponse
type SearchContactsOutput struct {
	_ struct{} `type:"structure"`

	// The contacts that meet the specified set of filter criteria, in sort order.
	Contacts []ContactData `type:"list"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The total number of contacts returned.
	TotalCount *int64 `type:"integer"`
}

// String returns the string representation
func (s SearchContactsOutput) String() string {
	return awsutil.Prettify(s)
}

const opSearchContacts = "SearchContacts"

// SearchContactsRequest returns a request value for making API operation for
// Alexa For Business.
//
// Searches contacts and lists the ones that meet a set of filter and sort criteria.
//
//    // Example sending a request using SearchContactsRequest.
//    req := client.SearchContactsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchContacts
func (c *Client) SearchContactsRequest(input *SearchContactsInput) SearchContactsRequest {
	op := &aws.Operation{
		Name:       opSearchContacts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchContactsInput{}
	}

	req := c.newRequest(op, input, &SearchContactsOutput{})
	return SearchContactsRequest{Request: req, Input: input, Copy: c.SearchContactsRequest}
}

// SearchContactsRequest is the request type for the
// SearchContacts API operation.
type SearchContactsRequest struct {
	*aws.Request
	Input *SearchContactsInput
	Copy  func(*SearchContactsInput) SearchContactsRequest
}

// Send marshals and sends the SearchContacts API request.
func (r SearchContactsRequest) Send(ctx context.Context) (*SearchContactsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SearchContactsResponse{
		SearchContactsOutput: r.Request.Data.(*SearchContactsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewSearchContactsRequestPaginator returns a paginator for SearchContacts.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.SearchContactsRequest(input)
//   p := alexaforbusiness.NewSearchContactsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewSearchContactsPaginator(req SearchContactsRequest) SearchContactsPaginator {
	return SearchContactsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *SearchContactsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// SearchContactsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type SearchContactsPaginator struct {
	aws.Pager
}

func (p *SearchContactsPaginator) CurrentPage() *SearchContactsOutput {
	return p.Pager.CurrentPage().(*SearchContactsOutput)
}

// SearchContactsResponse is the response type for the
// SearchContacts API operation.
type SearchContactsResponse struct {
	*SearchContactsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SearchContacts request.
func (r *SearchContactsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
