// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateGatewayRequest
type UpdateGatewayInput struct {
	_ struct{} `type:"structure"`

	// The updated description of the gateway.
	Description *string `type:"string"`

	// The ARN of the gateway to update.
	//
	// GatewayArn is a required field
	GatewayArn *string `type:"string" required:"true"`

	// The updated name of the gateway.
	Name *string `min:"1" type:"string"`

	// The updated software version of the gateway. The gateway automatically updates
	// its software version during normal operation.
	SoftwareVersion *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGatewayInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateGatewayInput"}

	if s.GatewayArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayArn"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.SoftwareVersion != nil && len(*s.SoftwareVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SoftwareVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateGatewayResponse
type UpdateGatewayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateGateway = "UpdateGateway"

// UpdateGatewayRequest returns a request value for making API operation for
// Alexa For Business.
//
// Updates the details of a gateway. If any optional field is not provided,
// the existing corresponding value is left unmodified.
//
//    // Example sending a request using UpdateGatewayRequest.
//    req := client.UpdateGatewayRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateGateway
func (c *Client) UpdateGatewayRequest(input *UpdateGatewayInput) UpdateGatewayRequest {
	op := &aws.Operation{
		Name:       opUpdateGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGatewayInput{}
	}

	req := c.newRequest(op, input, &UpdateGatewayOutput{})
	return UpdateGatewayRequest{Request: req, Input: input, Copy: c.UpdateGatewayRequest}
}

// UpdateGatewayRequest is the request type for the
// UpdateGateway API operation.
type UpdateGatewayRequest struct {
	*aws.Request
	Input *UpdateGatewayInput
	Copy  func(*UpdateGatewayInput) UpdateGatewayRequest
}

// Send marshals and sends the UpdateGateway API request.
func (r UpdateGatewayRequest) Send(ctx context.Context) (*UpdateGatewayResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateGatewayResponse{
		UpdateGatewayOutput: r.Request.Data.(*UpdateGatewayOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateGatewayResponse is the response type for the
// UpdateGateway API operation.
type UpdateGatewayResponse struct {
	*UpdateGatewayOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateGateway request.
func (r *UpdateGatewayResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
