// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package amplify

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Request structure for list branches request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListBranchesRequest
type ListBranchesInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// Maximum number of records to list in a single response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Pagination token. Set to null to start listing branches from start. If a
	// non-null pagination token is returned in a result, then pass its value in
	// here to list more branches.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBranchesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBranchesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListBranchesInput"}

	if s.AppId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AppId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBranchesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.AppId != nil {
		v := *s.AppId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "appId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Result structure for list branches request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListBranchesResult
type ListBranchesOutput struct {
	_ struct{} `type:"structure"`

	// List of branches for an Amplify App.
	//
	// Branches is a required field
	Branches []Branch `locationName:"branches" type:"list" required:"true"`

	// Pagination token. If non-null pagination token is returned in a result, then
	// pass its value in another request to fetch more entries.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBranchesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBranchesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Branches) > 0 {
		v := s.Branches

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "branches", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListBranches = "ListBranches"

// ListBranchesRequest returns a request value for making API operation for
// AWS Amplify.
//
// Lists branches for an Amplify App.
//
//    // Example sending a request using ListBranchesRequest.
//    req := client.ListBranchesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListBranches
func (c *Client) ListBranchesRequest(input *ListBranchesInput) ListBranchesRequest {
	op := &aws.Operation{
		Name:       opListBranches,
		HTTPMethod: "GET",
		HTTPPath:   "/apps/{appId}/branches",
	}

	if input == nil {
		input = &ListBranchesInput{}
	}

	req := c.newRequest(op, input, &ListBranchesOutput{})
	return ListBranchesRequest{Request: req, Input: input, Copy: c.ListBranchesRequest}
}

// ListBranchesRequest is the request type for the
// ListBranches API operation.
type ListBranchesRequest struct {
	*aws.Request
	Input *ListBranchesInput
	Copy  func(*ListBranchesInput) ListBranchesRequest
}

// Send marshals and sends the ListBranches API request.
func (r ListBranchesRequest) Send(ctx context.Context) (*ListBranchesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListBranchesResponse{
		ListBranchesOutput: r.Request.Data.(*ListBranchesOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListBranchesResponse is the response type for the
// ListBranches API operation.
type ListBranchesResponse struct {
	*ListBranchesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListBranches request.
func (r *ListBranchesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
