// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package athena

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetNamedQueryInput
type GetNamedQueryInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query. Use ListNamedQueries to get query IDs.
	//
	// NamedQueryId is a required field
	NamedQueryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetNamedQueryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetNamedQueryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetNamedQueryInput"}

	if s.NamedQueryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("NamedQueryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetNamedQueryOutput
type GetNamedQueryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the query.
	NamedQuery *NamedQuery `type:"structure"`
}

// String returns the string representation
func (s GetNamedQueryOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetNamedQuery = "GetNamedQuery"

// GetNamedQueryRequest returns a request value for making API operation for
// Amazon Athena.
//
// Returns information about a single query. Requires that you have access to
// the workgroup in which the query was saved.
//
//    // Example sending a request using GetNamedQueryRequest.
//    req := client.GetNamedQueryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetNamedQuery
func (c *Client) GetNamedQueryRequest(input *GetNamedQueryInput) GetNamedQueryRequest {
	op := &aws.Operation{
		Name:       opGetNamedQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetNamedQueryInput{}
	}

	req := c.newRequest(op, input, &GetNamedQueryOutput{})
	return GetNamedQueryRequest{Request: req, Input: input, Copy: c.GetNamedQueryRequest}
}

// GetNamedQueryRequest is the request type for the
// GetNamedQuery API operation.
type GetNamedQueryRequest struct {
	*aws.Request
	Input *GetNamedQueryInput
	Copy  func(*GetNamedQueryInput) GetNamedQueryRequest
}

// Send marshals and sends the GetNamedQuery API request.
func (r GetNamedQueryRequest) Send(ctx context.Context) (*GetNamedQueryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetNamedQueryResponse{
		GetNamedQueryOutput: r.Request.Data.(*GetNamedQueryOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetNamedQueryResponse is the response type for the
// GetNamedQuery API operation.
type GetNamedQueryResponse struct {
	*GetNamedQueryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetNamedQuery request.
func (r *GetNamedQueryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
