// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Describes scaling activity, which is a long-running process that represents
// a change to your Auto Scaling group, such as changing its size or replacing
// an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/Activity
type Activity struct {
	_ struct{} `type:"structure"`

	// The ID of the activity.
	//
	// ActivityId is a required field
	ActivityId *string `type:"string" required:"true"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The reason the activity began.
	//
	// Cause is a required field
	Cause *string `min:"1" type:"string" required:"true"`

	// A friendly, more verbose description of the activity.
	Description *string `type:"string"`

	// The details about the activity.
	Details *string `type:"string"`

	// The end time of the activity.
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A value between 0 and 100 that indicates the progress of the activity.
	Progress *int64 `type:"integer"`

	// The start time of the activity.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The current status of the activity.
	//
	// StatusCode is a required field
	StatusCode ScalingActivityStatusCode `type:"string" required:"true" enum:"true"`

	// A friendly, more verbose description of the activity status.
	StatusMessage *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Activity) String() string {
	return awsutil.Prettify(s)
}

// Describes a policy adjustment type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AdjustmentType
type AdjustmentType struct {
	_ struct{} `type:"structure"`

	// The policy adjustment type. The valid values are ChangeInCapacity, ExactCapacity,
	// and PercentChangeInCapacity.
	AdjustmentType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AdjustmentType) String() string {
	return awsutil.Prettify(s)
}

// Describes an alarm.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/Alarm
type Alarm struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the alarm.
	AlarmARN *string `min:"1" type:"string"`

	// The name of the alarm.
	AlarmName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Alarm) String() string {
	return awsutil.Prettify(s)
}

// Describes an Auto Scaling group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AutoScalingGroup
type AutoScalingGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Auto Scaling group.
	AutoScalingGroupARN *string `min:"1" type:"string"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more Availability Zones for the group.
	//
	// AvailabilityZones is a required field
	AvailabilityZones []string `min:"1" type:"list" required:"true"`

	// The date and time the group was created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The amount of time, in seconds, after a scaling activity completes before
	// another scaling activity can start.
	//
	// DefaultCooldown is a required field
	DefaultCooldown *int64 `type:"integer" required:"true"`

	// The desired size of the group.
	//
	// DesiredCapacity is a required field
	DesiredCapacity *int64 `type:"integer" required:"true"`

	// The metrics enabled for the group.
	EnabledMetrics []EnabledMetric `type:"list"`

	// The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before
	// checking the health status of an EC2 instance that has come into service.
	HealthCheckGracePeriod *int64 `type:"integer"`

	// The service to use for the health checks. The valid values are EC2 and ELB.
	// If you configure an Auto Scaling group to use ELB health checks, it considers
	// the instance unhealthy if it fails either the EC2 status checks or the load
	// balancer health checks.
	//
	// HealthCheckType is a required field
	HealthCheckType *string `min:"1" type:"string" required:"true"`

	// The EC2 instances associated with the group.
	Instances []Instance `type:"list"`

	// The name of the associated launch configuration.
	LaunchConfigurationName *string `min:"1" type:"string"`

	// The launch template for the group.
	LaunchTemplate *LaunchTemplateSpecification `type:"structure"`

	// One or more load balancers associated with the group.
	LoadBalancerNames []string `type:"list"`

	// The maximum size of the group.
	//
	// MaxSize is a required field
	MaxSize *int64 `type:"integer" required:"true"`

	// The minimum size of the group.
	//
	// MinSize is a required field
	MinSize *int64 `type:"integer" required:"true"`

	// The mixed instances policy for the group.
	MixedInstancesPolicy *MixedInstancesPolicy `type:"structure"`

	// Indicates whether newly launched instances are protected from termination
	// by Amazon EC2 Auto Scaling when scaling in.
	NewInstancesProtectedFromScaleIn *bool `type:"boolean"`

	// The name of the placement group into which to launch your instances, if any.
	PlacementGroup *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling
	// group uses to call other AWS services on your behalf.
	ServiceLinkedRoleARN *string `min:"1" type:"string"`

	// The current state of the group when DeleteAutoScalingGroup is in progress.
	Status *string `min:"1" type:"string"`

	// The suspended processes associated with the group.
	SuspendedProcesses []SuspendedProcess `type:"list"`

	// The tags for the group.
	Tags []TagDescription `type:"list"`

	// The Amazon Resource Names (ARN) of the target groups for your load balancer.
	TargetGroupARNs []string `type:"list"`

	// The termination policies for the group.
	TerminationPolicies []string `type:"list"`

	// One or more subnet IDs, if applicable, separated by commas.
	VPCZoneIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AutoScalingGroup) String() string {
	return awsutil.Prettify(s)
}

// Describes an EC2 instance associated with an Auto Scaling group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AutoScalingInstanceDetails
type AutoScalingInstanceDetails struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group for the instance.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The Availability Zone for the instance.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `min:"1" type:"string" required:"true"`

	// The last reported health status of this instance. "Healthy" means that the
	// instance is healthy and should remain in service. "Unhealthy" means that
	// the instance is unhealthy and Amazon EC2 Auto Scaling should terminate and
	// replace it.
	//
	// HealthStatus is a required field
	HealthStatus *string `min:"1" type:"string" required:"true"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// The launch configuration used to launch the instance. This value is not available
	// if you attached the instance to the Auto Scaling group.
	LaunchConfigurationName *string `min:"1" type:"string"`

	// The launch template for the instance.
	LaunchTemplate *LaunchTemplateSpecification `type:"structure"`

	// The lifecycle state for the instance.
	//
	// LifecycleState is a required field
	LifecycleState *string `min:"1" type:"string" required:"true"`

	// Indicates whether the instance is protected from termination by Amazon EC2
	// Auto Scaling when scaling in.
	//
	// ProtectedFromScaleIn is a required field
	ProtectedFromScaleIn *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s AutoScalingInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// Describes a block device mapping.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/BlockDeviceMapping
type BlockDeviceMapping struct {
	_ struct{} `type:"structure"`

	// The device name exposed to the EC2 instance (for example, /dev/sdh or xvdh).
	// For more information, see Device Naming on Linux Instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// DeviceName is a required field
	DeviceName *string `min:"1" type:"string" required:"true"`

	// The information about the Amazon EBS volume.
	Ebs *Ebs `type:"structure"`

	// Suppresses a device mapping.
	//
	// If this parameter is true for the root device, the instance might fail the
	// EC2 health check. In that case, Amazon EC2 Auto Scaling launches a replacement
	// instance.
	NoDevice *bool `type:"boolean"`

	// The name of the virtual device (for example, ephemeral0).
	VirtualName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BlockDeviceMapping) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BlockDeviceMapping) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BlockDeviceMapping"}

	if s.DeviceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceName"))
	}
	if s.DeviceName != nil && len(*s.DeviceName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DeviceName", 1))
	}
	if s.VirtualName != nil && len(*s.VirtualName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VirtualName", 1))
	}
	if s.Ebs != nil {
		if err := s.Ebs.Validate(); err != nil {
			invalidParams.AddNested("Ebs", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a CloudWatch metric of your choosing for a target tracking scaling
// policy to use with Amazon EC2 Auto Scaling.
//
// To create your customized metric specification:
//
//    * Add values for each required parameter from CloudWatch. You can use
//    an existing metric, or a new metric that you create. To use your own metric,
//    you must first publish the metric to CloudWatch. For more information,
//    see Publish Custom Metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html)
//    in the Amazon CloudWatch User Guide.
//
//    * Choose a metric that changes proportionally with capacity. The value
//    of the metric should increase or decrease in inverse proportion to the
//    number of capacity units. That is, the value of the metric should decrease
//    when capacity increases.
//
// For more information about CloudWatch, see Amazon CloudWatch Concepts (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CustomizedMetricSpecification
type CustomizedMetricSpecification struct {
	_ struct{} `type:"structure"`

	// The dimensions of the metric.
	//
	// Conditional: If you published your metric with dimensions, you must specify
	// the same dimensions in your scaling policy.
	Dimensions []MetricDimension `type:"list"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true"`

	// The namespace of the metric.
	//
	// Namespace is a required field
	Namespace *string `type:"string" required:"true"`

	// The statistic of the metric.
	//
	// Statistic is a required field
	Statistic MetricStatistic `type:"string" required:"true" enum:"true"`

	// The unit of the metric.
	Unit *string `type:"string"`
}

// String returns the string representation
func (s CustomizedMetricSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomizedMetricSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CustomizedMetricSpecification"}

	if s.MetricName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricName"))
	}

	if s.Namespace == nil {
		invalidParams.Add(aws.NewErrParamRequired("Namespace"))
	}
	if len(s.Statistic) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Statistic"))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an Amazon EBS volume. Used in combination with BlockDeviceMapping.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/Ebs
type Ebs struct {
	_ struct{} `type:"structure"`

	// Indicates whether the volume is deleted on instance termination. The default
	// value is true.
	DeleteOnTermination *bool `type:"boolean"`

	// Specifies whether the volume should be encrypted. Encrypted EBS volumes must
	// be attached to instances that support Amazon EBS encryption. Volumes that
	// are created from encrypted snapshots are automatically encrypted. There is
	// no way to create an encrypted volume from an unencrypted snapshot or an unencrypted
	// volume from an encrypted snapshot. If your AMI uses encrypted volumes, you
	// can only launch it on supported instance types. For more information, see
	// Amazon EBS Encryption (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	Encrypted *bool `type:"boolean"`

	// The number of I/O operations per second (IOPS) to provision for the volume.
	// For more information, see Amazon EBS Volume Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// Conditional: This parameter is required when the volume type is io1. (Not
	// used with standard, gp2, st1, or sc1 volumes.)
	Iops *int64 `min:"100" type:"integer"`

	// The ID of the snapshot. This parameter is optional if you specify a volume
	// size.
	SnapshotId *string `min:"1" type:"string"`

	// The volume size, in GiB.
	//
	// Constraints: 1-1,024 for standard, 4-16,384 for io1, 1-16,384 for gp2, and
	// 500-16,384 for st1 and sc1. If you specify a snapshot, the volume size must
	// be equal to or larger than the snapshot size.
	//
	// Default: If you create a volume from a snapshot and you don't specify a volume
	// size, the default is the snapshot size.
	//
	// At least one of VolumeSize or SnapshotId is required.
	VolumeSize *int64 `min:"1" type:"integer"`

	// The volume type, which can be standard for Magnetic, io1 for Provisioned
	// IOPS SSD, gp2 for General Purpose SSD, st1 for Throughput Optimized HDD,
	// or sc1 for Cold HDD. For more information, see Amazon EBS Volume Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// Valid values: standard | io1 | gp2 | st1 | sc1
	VolumeType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Ebs) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ebs) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Ebs"}
	if s.Iops != nil && *s.Iops < 100 {
		invalidParams.Add(aws.NewErrParamMinValue("Iops", 100))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SnapshotId", 1))
	}
	if s.VolumeSize != nil && *s.VolumeSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("VolumeSize", 1))
	}
	if s.VolumeType != nil && len(*s.VolumeType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VolumeType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an enabled metric.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnabledMetric
type EnabledMetric struct {
	_ struct{} `type:"structure"`

	// The granularity of the metric. The only valid value is 1Minute.
	Granularity *string `min:"1" type:"string"`

	// One of the following metrics:
	//
	//    * GroupMinSize
	//
	//    * GroupMaxSize
	//
	//    * GroupDesiredCapacity
	//
	//    * GroupInServiceInstances
	//
	//    * GroupPendingInstances
	//
	//    * GroupStandbyInstances
	//
	//    * GroupTerminatingInstances
	//
	//    * GroupTotalInstances
	Metric *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EnabledMetric) String() string {
	return awsutil.Prettify(s)
}

// Describes a scheduled action that could not be created, updated, or deleted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/FailedScheduledUpdateGroupActionRequest
type FailedScheduledUpdateGroupActionRequest struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `min:"1" type:"string"`

	// The error message accompanying the error code.
	ErrorMessage *string `type:"string"`

	// The name of the scheduled action.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s FailedScheduledUpdateGroupActionRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes a filter.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/Filter
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. The valid values are: "auto-scaling-group", "key",
	// "value", and "propagate-at-launch".
	Name *string `type:"string"`

	// The value of the filter.
	Values []string `type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// Describes an EC2 instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/Instance
type Instance struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which the instance is running.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `min:"1" type:"string" required:"true"`

	// The last reported health status of the instance. "Healthy" means that the
	// instance is healthy and should remain in service. "Unhealthy" means that
	// the instance is unhealthy and that Amazon EC2 Auto Scaling should terminate
	// and replace it.
	//
	// HealthStatus is a required field
	HealthStatus *string `min:"1" type:"string" required:"true"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// The launch configuration associated with the instance.
	LaunchConfigurationName *string `min:"1" type:"string"`

	// The launch template for the instance.
	LaunchTemplate *LaunchTemplateSpecification `type:"structure"`

	// A description of the current lifecycle state. The Quarantined state is not
	// used.
	//
	// LifecycleState is a required field
	LifecycleState LifecycleState `type:"string" required:"true" enum:"true"`

	// Indicates whether the instance is protected from termination by Amazon EC2
	// Auto Scaling when scaling in.
	//
	// ProtectedFromScaleIn is a required field
	ProtectedFromScaleIn *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// Describes whether detailed monitoring is enabled for the Auto Scaling instances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/InstanceMonitoring
type InstanceMonitoring struct {
	_ struct{} `type:"structure"`

	// If true, detailed monitoring is enabled. Otherwise, basic monitoring is enabled.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s InstanceMonitoring) String() string {
	return awsutil.Prettify(s)
}

// Describes an instances distribution for an Auto Scaling group with MixedInstancesPolicy.
//
// The instances distribution specifies the distribution of On-Demand Instances
// and Spot Instances, the maximum price to pay for Spot Instances, and how
// the Auto Scaling group allocates instance types.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/InstancesDistribution
type InstancesDistribution struct {
	_ struct{} `type:"structure"`

	// Indicates how to allocate instance types to fulfill On-Demand capacity.
	//
	// The only valid value is prioritized, which is also the default value. This
	// strategy uses the order of instance type overrides for the LaunchTemplate
	// to define the launch priority of each instance type. The first instance type
	// in the array is prioritized higher than the last. If all your On-Demand capacity
	// cannot be fulfilled using your highest priority instance, then the Auto Scaling
	// groups launches the remaining capacity using the second priority instance
	// type, and so on.
	OnDemandAllocationStrategy *string `type:"string"`

	// The minimum amount of the Auto Scaling group's capacity that must be fulfilled
	// by On-Demand Instances. This base portion is provisioned first as your group
	// scales.
	//
	// The default value is 0. If you leave this parameter set to 0, On-Demand Instances
	// are launched as a percentage of the Auto Scaling group's desired capacity,
	// per the OnDemandPercentageAboveBaseCapacity setting.
	OnDemandBaseCapacity *int64 `type:"integer"`

	// Controls the percentages of On-Demand Instances and Spot Instances for your
	// additional capacity beyond OnDemandBaseCapacity.
	//
	// The range is 0–100. The default value is 100. If you leave this parameter
	// set to 100, the percentages are 100% for On-Demand Instances and 0% for Spot
	// Instances.
	OnDemandPercentageAboveBaseCapacity *int64 `type:"integer"`

	// Indicates how to allocate Spot capacity across Spot pools.
	//
	// The only valid value is lowest-price, which is also the default value. The
	// Auto Scaling group selects the cheapest Spot pools and evenly allocates your
	// Spot capacity across the number of Spot pools that you specify.
	SpotAllocationStrategy *string `type:"string"`

	// The number of Spot pools to use to allocate your Spot capacity. The Spot
	// pools are determined from the different instance types in the Overrides array
	// of LaunchTemplate.
	//
	// The range is 1–20 and the default is 2.
	SpotInstancePools *int64 `type:"integer"`

	// The maximum price per unit hour that you are willing to pay for a Spot Instance.
	// If you leave the value of this parameter blank (which is the default), the
	// maximum Spot price is set at the On-Demand price.
	//
	// To remove a value that you previously set, include the parameter but leave
	// the value blank.
	SpotMaxPrice *string `type:"string"`
}

// String returns the string representation
func (s InstancesDistribution) String() string {
	return awsutil.Prettify(s)
}

// Describes a launch configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/LaunchConfiguration
type LaunchConfiguration struct {
	_ struct{} `type:"structure"`

	// [EC2-VPC] Indicates whether to assign a public IP address to each instance.
	AssociatePublicIpAddress *bool `type:"boolean"`

	// A block device mapping, which specifies the block devices for the instance.
	BlockDeviceMappings []BlockDeviceMapping `type:"list"`

	// The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to.
	// This parameter can only be used if you are launching EC2-Classic instances.
	// For more information, see ClassicLink (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon EC2 User Guide for Linux Instances and Linking EC2-Classic
	// Instances to a VPC (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink)
	// in the Amazon EC2 Auto Scaling User Guide.
	ClassicLinkVPCId *string `min:"1" type:"string"`

	// The IDs of one or more security groups for the VPC specified in ClassicLinkVPCId.
	// For more information, see ClassicLink (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon EC2 User Guide for Linux Instances and Linking EC2-Classic
	// Instances to a VPC (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// Conditional: This parameter is required if you specify a ClassicLink-enabled
	// VPC, and cannot be used otherwise.
	ClassicLinkVPCSecurityGroups []string `type:"list"`

	// The creation date and time for the launch configuration.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Controls whether the instance is optimized for EBS I/O (true) or not (false).
	EbsOptimized *bool `type:"boolean"`

	// The name or Amazon Resource Name (ARN) of the instance profile associated
	// with the IAM role for the instance.
	IamInstanceProfile *string `min:"1" type:"string"`

	// The ID of the Amazon Machine Image (AMI).
	//
	// ImageId is a required field
	ImageId *string `min:"1" type:"string" required:"true"`

	// Controls whether instances in this group are launched with detailed (true)
	// or basic (false) monitoring.
	InstanceMonitoring *InstanceMonitoring `type:"structure"`

	// The instance type for the instances.
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// The ID of the kernel associated with the AMI.
	KernelId *string `min:"1" type:"string"`

	// The name of the key pair.
	KeyName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the launch configuration.
	LaunchConfigurationARN *string `min:"1" type:"string"`

	// The name of the launch configuration.
	//
	// LaunchConfigurationName is a required field
	LaunchConfigurationName *string `min:"1" type:"string" required:"true"`

	// The tenancy of the instance, either default or dedicated. An instance with
	// dedicated tenancy runs in an isolated, single-tenant hardware and can only
	// be launched into a VPC.
	PlacementTenancy *string `min:"1" type:"string"`

	// The ID of the RAM disk associated with the AMI.
	RamdiskId *string `min:"1" type:"string"`

	// The security groups to associate with the instances.
	SecurityGroups []string `type:"list"`

	// The price to bid when launching Spot Instances.
	SpotPrice *string `min:"1" type:"string"`

	// The user data available to the instances.
	UserData *string `type:"string"`
}

// String returns the string representation
func (s LaunchConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Describes a launch template and overrides.
//
// The overrides are used to override the instance type specified by the launch
// template with multiple instance types that can be used to launch On-Demand
// Instances and Spot Instances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/LaunchTemplate
type LaunchTemplate struct {
	_ struct{} `type:"structure"`

	// The launch template to use. You must specify either the launch template ID
	// or launch template name in the request.
	LaunchTemplateSpecification *LaunchTemplateSpecification `type:"structure"`

	// Any parameters that you specify override the same parameters in the launch
	// template. Currently, the only supported override is instance type.
	//
	// You must specify between 2 and 20 overrides.
	Overrides []LaunchTemplateOverrides `type:"list"`
}

// String returns the string representation
func (s LaunchTemplate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LaunchTemplate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LaunchTemplate"}
	if s.LaunchTemplateSpecification != nil {
		if err := s.LaunchTemplateSpecification.Validate(); err != nil {
			invalidParams.AddNested("LaunchTemplateSpecification", err.(aws.ErrInvalidParams))
		}
	}
	if s.Overrides != nil {
		for i, v := range s.Overrides {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Overrides", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an override for a launch template.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/LaunchTemplateOverrides
type LaunchTemplateOverrides struct {
	_ struct{} `type:"structure"`

	// The instance type.
	//
	// For information about available instance types, see Available Instance Types
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes)
	// in the Amazon Elastic Compute Cloud User Guide.
	InstanceType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LaunchTemplateOverrides) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LaunchTemplateOverrides) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LaunchTemplateOverrides"}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a launch template and the launch template version.
//
// The launch template that is specified must be configured for use with an
// Auto Scaling group. For more information, see Creating a Launch Template
// for an Auto Scaling Group (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html)
// in the Amazon EC2 Auto Scaling User Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/LaunchTemplateSpecification
type LaunchTemplateSpecification struct {
	_ struct{} `type:"structure"`

	// The ID of the launch template. You must specify either a template ID or a
	// template name.
	LaunchTemplateId *string `min:"1" type:"string"`

	// The name of the launch template. You must specify either a template name
	// or a template ID.
	LaunchTemplateName *string `min:"3" type:"string"`

	// The version number, $Latest, or $Default. If the value is $Latest, Amazon
	// EC2 Auto Scaling selects the latest version of the launch template when launching
	// instances. If the value is $Default, Amazon EC2 Auto Scaling selects the
	// default version of the launch template when launching instances. The default
	// value is $Default.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LaunchTemplateSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LaunchTemplateSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LaunchTemplateSpecification"}
	if s.LaunchTemplateId != nil && len(*s.LaunchTemplateId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LaunchTemplateId", 1))
	}
	if s.LaunchTemplateName != nil && len(*s.LaunchTemplateName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("LaunchTemplateName", 3))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a lifecycle hook, which tells Amazon EC2 Auto Scaling that you
// want to perform an action whenever it launches instances or whenever it terminates
// instances. Used in response to DescribeLifecycleHooks.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/LifecycleHook
type LifecycleHook struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group for the lifecycle hook.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// Defines the action the Auto Scaling group should take when the lifecycle
	// hook timeout elapses or if an unexpected failure occurs. The possible values
	// are CONTINUE and ABANDON.
	DefaultResult *string `type:"string"`

	// The maximum time, in seconds, that an instance can remain in a Pending:Wait
	// or Terminating:Wait state. The maximum is 172800 seconds (48 hours) or 100
	// times HeartbeatTimeout, whichever is smaller.
	GlobalTimeout *int64 `type:"integer"`

	// The maximum time, in seconds, that can elapse before the lifecycle hook times
	// out. If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the
	// action that you specified in the DefaultResult parameter.
	HeartbeatTimeout *int64 `type:"integer"`

	// The name of the lifecycle hook.
	LifecycleHookName *string `min:"1" type:"string"`

	// The state of the EC2 instance to which to attach the lifecycle hook. The
	// following are possible values:
	//
	//    * autoscaling:EC2_INSTANCE_LAUNCHING
	//
	//    * autoscaling:EC2_INSTANCE_TERMINATING
	LifecycleTransition *string `type:"string"`

	// Additional information that is included any time Amazon EC2 Auto Scaling
	// sends a message to the notification target.
	NotificationMetadata *string `min:"1" type:"string"`

	// The ARN of the target that Amazon EC2 Auto Scaling sends notifications to
	// when an instance is in the transition state for the lifecycle hook. The notification
	// target can be either an SQS queue or an SNS topic.
	NotificationTargetARN *string `min:"1" type:"string"`

	// The ARN of the IAM role that allows the Auto Scaling group to publish to
	// the specified notification target.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LifecycleHook) String() string {
	return awsutil.Prettify(s)
}

// Describes a lifecycle hook. Used in combination with CreateAutoScalingGroup.
//
// A lifecycle hook tells Amazon EC2 Auto Scaling to perform an action on an
// instance when the instance launches (before it is put into service) or as
// the instance terminates (before it is fully terminated).
//
// This step is a part of the procedure for creating a lifecycle hook for an
// Auto Scaling group:
//
// (Optional) Create a Lambda function and a rule that allows CloudWatch Events
// to invoke your Lambda function when Amazon EC2 Auto Scaling launches or terminates
// instances.
//
// (Optional) Create a notification target and an IAM role. The target can be
// either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon
// EC2 Auto Scaling to publish lifecycle notifications to the target.
//
// Create the lifecycle hook. Specify whether the hook is used when the instances
// launch or terminate.
//
// If you need more time, record the lifecycle action heartbeat to keep the
// instance in a pending state using using RecordLifecycleActionHeartbeat.
//
// If you finish before the timeout period ends, complete the lifecycle action
// using CompleteLifecycleAction.
//
// For more information, see Amazon EC2 Auto Scaling Lifecycle Hooks (https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// You can view the lifecycle hooks for an Auto Scaling group using DescribeLifecycleHooks.
// You can modify an existing lifecycle hook or create new lifecycle hooks using
// PutLifecycleHook. If you are no longer using a lifecycle hook, you can delete
// it using DeleteLifecycleHook.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/LifecycleHookSpecification
type LifecycleHookSpecification struct {
	_ struct{} `type:"structure"`

	// Defines the action the Auto Scaling group should take when the lifecycle
	// hook timeout elapses or if an unexpected failure occurs. The valid values
	// are CONTINUE and ABANDON. The default value is ABANDON.
	DefaultResult *string `type:"string"`

	// The maximum time, in seconds, that can elapse before the lifecycle hook times
	// out.
	//
	// If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action
	// that you specified in the DefaultResult parameter. You can prevent the lifecycle
	// hook from timing out by calling RecordLifecycleActionHeartbeat.
	HeartbeatTimeout *int64 `type:"integer"`

	// The name of the lifecycle hook.
	//
	// LifecycleHookName is a required field
	LifecycleHookName *string `min:"1" type:"string" required:"true"`

	// The state of the EC2 instance to which you want to attach the lifecycle hook.
	// The valid values are:
	//
	//    * autoscaling:EC2_INSTANCE_LAUNCHING
	//
	//    * autoscaling:EC2_INSTANCE_TERMINATING
	//
	// LifecycleTransition is a required field
	LifecycleTransition *string `type:"string" required:"true"`

	// Additional information that you want to include any time Amazon EC2 Auto
	// Scaling sends a message to the notification target.
	NotificationMetadata *string `min:"1" type:"string"`

	// The ARN of the target that Amazon EC2 Auto Scaling sends notifications to
	// when an instance is in the transition state for the lifecycle hook. The notification
	// target can be either an SQS queue or an SNS topic.
	NotificationTargetARN *string `type:"string"`

	// The ARN of the IAM role that allows the Auto Scaling group to publish to
	// the specified notification target, for example, an Amazon SNS topic or an
	// Amazon SQS queue.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LifecycleHookSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleHookSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LifecycleHookSpecification"}

	if s.LifecycleHookName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LifecycleHookName"))
	}
	if s.LifecycleHookName != nil && len(*s.LifecycleHookName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LifecycleHookName", 1))
	}

	if s.LifecycleTransition == nil {
		invalidParams.Add(aws.NewErrParamRequired("LifecycleTransition"))
	}
	if s.NotificationMetadata != nil && len(*s.NotificationMetadata) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NotificationMetadata", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the state of a Classic Load Balancer.
//
// If you specify a load balancer when creating the Auto Scaling group, the
// state of the load balancer is InService.
//
// If you attach a load balancer to an existing Auto Scaling group, the initial
// state is Adding. The state transitions to Added after all instances in the
// group are registered with the load balancer. If Elastic Load Balancing health
// checks are enabled for the load balancer, the state transitions to InService
// after at least one instance in the group passes the health check. If EC2
// health checks are enabled instead, the load balancer remains in the Added
// state.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/LoadBalancerState
type LoadBalancerState struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `min:"1" type:"string"`

	// One of the following load balancer states:
	//
	//    * Adding - The instances in the group are being registered with the load
	//    balancer.
	//
	//    * Added - All instances in the group are registered with the load balancer.
	//
	//    * InService - At least one instance in the group passed an ELB health
	//    check.
	//
	//    * Removing - The instances in the group are being deregistered from the
	//    load balancer. If connection draining is enabled, Elastic Load Balancing
	//    waits for in-flight requests to complete before deregistering the instances.
	//
	//    * Removed - All instances in the group are deregistered from the load
	//    balancer.
	State *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LoadBalancerState) String() string {
	return awsutil.Prettify(s)
}

// Describes the state of a target group.
//
// If you attach a target group to an existing Auto Scaling group, the initial
// state is Adding. The state transitions to Added after all Auto Scaling instances
// are registered with the target group. If Elastic Load Balancing health checks
// are enabled, the state transitions to InService after at least one Auto Scaling
// instance passes the health check. If EC2 health checks are enabled instead,
// the target group remains in the Added state.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/LoadBalancerTargetGroupState
type LoadBalancerTargetGroupState struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group.
	LoadBalancerTargetGroupARN *string `min:"1" type:"string"`

	// The state of the target group.
	//
	//    * Adding - The Auto Scaling instances are being registered with the target
	//    group.
	//
	//    * Added - All Auto Scaling instances are registered with the target group.
	//
	//    * InService - At least one Auto Scaling instance passed an ELB health
	//    check.
	//
	//    * Removing - The Auto Scaling instances are being deregistered from the
	//    target group. If connection draining is enabled, Elastic Load Balancing
	//    waits for in-flight requests to complete before deregistering the instances.
	//
	//    * Removed - All Auto Scaling instances are deregistered from the target
	//    group.
	State *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LoadBalancerTargetGroupState) String() string {
	return awsutil.Prettify(s)
}

// Describes a metric.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/MetricCollectionType
type MetricCollectionType struct {
	_ struct{} `type:"structure"`

	// One of the following metrics:
	//
	//    * GroupMinSize
	//
	//    * GroupMaxSize
	//
	//    * GroupDesiredCapacity
	//
	//    * GroupInServiceInstances
	//
	//    * GroupPendingInstances
	//
	//    * GroupStandbyInstances
	//
	//    * GroupTerminatingInstances
	//
	//    * GroupTotalInstances
	Metric *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MetricCollectionType) String() string {
	return awsutil.Prettify(s)
}

// Describes the dimension of a metric.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/MetricDimension
type MetricDimension struct {
	_ struct{} `type:"structure"`

	// The name of the dimension.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of the dimension.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MetricDimension) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDimension) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MetricDimension"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a granularity of a metric.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/MetricGranularityType
type MetricGranularityType struct {
	_ struct{} `type:"structure"`

	// The granularity. The only valid value is 1Minute.
	Granularity *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MetricGranularityType) String() string {
	return awsutil.Prettify(s)
}

// Describes a mixed instances policy for an Auto Scaling group. With mixed
// instances, your Auto Scaling group can provision a combination of On-Demand
// Instances and Spot Instances across multiple instance types. Used in combination
// with CreateAutoScalingGroup. For more information, see Auto Scaling Groups
// with Multiple Instance Types and Purchase Options (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// When you create your Auto Scaling group, you can specify a launch configuration
// or template as a parameter for the top-level object, or you can specify a
// mixed instances policy, but not both at the same time.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/MixedInstancesPolicy
type MixedInstancesPolicy struct {
	_ struct{} `type:"structure"`

	// The instances distribution to use.
	//
	// If you leave this parameter unspecified when creating the group, the default
	// values are used.
	InstancesDistribution *InstancesDistribution `type:"structure"`

	// The launch template and overrides.
	//
	// This parameter is required when creating an Auto Scaling group with a mixed
	// instances policy, but is not required when updating the group.
	LaunchTemplate *LaunchTemplate `type:"structure"`
}

// String returns the string representation
func (s MixedInstancesPolicy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MixedInstancesPolicy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MixedInstancesPolicy"}
	if s.LaunchTemplate != nil {
		if err := s.LaunchTemplate.Validate(); err != nil {
			invalidParams.AddNested("LaunchTemplate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a notification.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/NotificationConfiguration
type NotificationConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// One of the following event notification types:
	//
	//    * autoscaling:EC2_INSTANCE_LAUNCH
	//
	//    * autoscaling:EC2_INSTANCE_LAUNCH_ERROR
	//
	//    * autoscaling:EC2_INSTANCE_TERMINATE
	//
	//    * autoscaling:EC2_INSTANCE_TERMINATE_ERROR
	//
	//    * autoscaling:TEST_NOTIFICATION
	NotificationType *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (Amazon SNS) topic.
	TopicARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s NotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Represents a predefined metric for a target tracking scaling policy to use
// with Amazon EC2 Auto Scaling.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PredefinedMetricSpecification
type PredefinedMetricSpecification struct {
	_ struct{} `type:"structure"`

	// The metric type.
	//
	// PredefinedMetricType is a required field
	PredefinedMetricType MetricType `type:"string" required:"true" enum:"true"`

	// Identifies the resource associated with the metric type. The following predefined
	// metrics are available:
	//
	//    * ASGAverageCPUUtilization - Average CPU utilization of the Auto Scaling
	//    group.
	//
	//    * ASGAverageNetworkIn - Average number of bytes received on all network
	//    interfaces by the Auto Scaling group.
	//
	//    * ASGAverageNetworkOut - Average number of bytes sent out on all network
	//    interfaces by the Auto Scaling group.
	//
	//    * ALBRequestCountPerTarget - Number of requests completed per target in
	//    an Application Load Balancer or a Network Load Balancer target group.
	//
	// For predefined metric types ASGAverageCPUUtilization, ASGAverageNetworkIn,
	// and ASGAverageNetworkOut, the parameter must not be specified as the resource
	// associated with the metric type is the Auto Scaling group. For predefined
	// metric type ALBRequestCountPerTarget, the parameter must be specified in
	// the format: app/load-balancer-name/load-balancer-id/targetgroup/target-group-name/target-group-id
	// , where app/load-balancer-name/load-balancer-id is the final portion of the
	// load balancer ARN, and targetgroup/target-group-name/target-group-id is the
	// final portion of the target group ARN. The target group must be attached
	// to the Auto Scaling group.
	ResourceLabel *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PredefinedMetricSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredefinedMetricSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PredefinedMetricSpecification"}
	if len(s.PredefinedMetricType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("PredefinedMetricType"))
	}
	if s.ResourceLabel != nil && len(*s.ResourceLabel) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceLabel", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a process type.
//
// For more information, see Scaling Processes (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html#process-types)
// in the Amazon EC2 Auto Scaling User Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ProcessType
type ProcessType struct {
	_ struct{} `type:"structure"`

	// One of the following processes:
	//
	//    * Launch
	//
	//    * Terminate
	//
	//    * AddToLoadBalancer
	//
	//    * AlarmNotification
	//
	//    * AZRebalance
	//
	//    * HealthCheck
	//
	//    * ReplaceUnhealthy
	//
	//    * ScheduledActions
	//
	// ProcessName is a required field
	ProcessName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ProcessType) String() string {
	return awsutil.Prettify(s)
}

// Describes a scaling policy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ScalingPolicy
type ScalingPolicy struct {
	_ struct{} `type:"structure"`

	// The adjustment type, which specifies how ScalingAdjustment is interpreted.
	// The valid values are ChangeInCapacity, ExactCapacity, and PercentChangeInCapacity.
	AdjustmentType *string `min:"1" type:"string"`

	// The CloudWatch alarms related to the policy.
	Alarms []Alarm `type:"list"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The amount of time, in seconds, after a scaling activity completes before
	// any further dynamic scaling activities can start.
	Cooldown *int64 `type:"integer"`

	// The estimated time, in seconds, until a newly launched instance can contribute
	// to the CloudWatch metrics.
	EstimatedInstanceWarmup *int64 `type:"integer"`

	// The aggregation type for the CloudWatch metrics. The valid values are Minimum,
	// Maximum, and Average.
	MetricAggregationType *string `min:"1" type:"string"`

	// The minimum number of instances to scale. If the value of AdjustmentType
	// is PercentChangeInCapacity, the scaling policy changes the DesiredCapacity
	// of the Auto Scaling group by at least this many instances. Otherwise, the
	// error is ValidationError.
	MinAdjustmentMagnitude *int64 `type:"integer"`

	// Available for backward compatibility. Use MinAdjustmentMagnitude instead.
	MinAdjustmentStep *int64 `deprecated:"true" type:"integer"`

	// The Amazon Resource Name (ARN) of the policy.
	PolicyARN *string `min:"1" type:"string"`

	// The name of the scaling policy.
	PolicyName *string `min:"1" type:"string"`

	// The policy type. The valid values are SimpleScaling and StepScaling.
	PolicyType *string `min:"1" type:"string"`

	// The amount by which to scale, based on the specified adjustment type. A positive
	// value adds to the current capacity while a negative number removes from the
	// current capacity.
	ScalingAdjustment *int64 `type:"integer"`

	// A set of adjustments that enable you to scale based on the size of the alarm
	// breach.
	StepAdjustments []StepAdjustment `type:"list"`

	// A target tracking scaling policy.
	TargetTrackingConfiguration *TargetTrackingConfiguration `type:"structure"`
}

// String returns the string representation
func (s ScalingPolicy) String() string {
	return awsutil.Prettify(s)
}

// Describes a scheduled scaling action. Used in response to DescribeScheduledActions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ScheduledUpdateGroupAction
type ScheduledUpdateGroupAction struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The number of instances you prefer to maintain in the group.
	DesiredCapacity *int64 `type:"integer"`

	// The date and time that the action is scheduled to end.
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The maximum size of the group.
	MaxSize *int64 `type:"integer"`

	// The minimum size of the group.
	MinSize *int64 `type:"integer"`

	// The recurring schedule for the action.
	Recurrence *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the scheduled action.
	ScheduledActionARN *string `min:"1" type:"string"`

	// The name of the scheduled action.
	ScheduledActionName *string `min:"1" type:"string"`

	// The date and time that the action is scheduled to begin.
	//
	// When StartTime and EndTime are specified with Recurrence, they form the boundaries
	// of when the recurring action starts and stops.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// This parameter is deprecated.
	Time *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ScheduledUpdateGroupAction) String() string {
	return awsutil.Prettify(s)
}

// Describes one or more scheduled scaling action updates for a specified Auto
// Scaling group. Used in combination with BatchPutScheduledUpdateGroupAction.
//
// When updating a scheduled scaling action, all optional parameters are left
// unchanged if not specified.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ScheduledUpdateGroupActionRequest
type ScheduledUpdateGroupActionRequest struct {
	_ struct{} `type:"structure"`

	// The number of EC2 instances that should be running in the group.
	DesiredCapacity *int64 `type:"integer"`

	// The time for the recurring schedule to end. Amazon EC2 Auto Scaling does
	// not perform the action after this time.
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The maximum size of the group.
	MaxSize *int64 `type:"integer"`

	// The minimum size of the group.
	MinSize *int64 `type:"integer"`

	// The recurring schedule for the action, in Unix cron syntax format. This format
	// consists of five fields separated by white spaces: [Minute] [Hour] [Day_of_Month]
	// [Month_of_Year] [Day_of_Week]. The value must be in quotes (for example,
	// "30 0 1 1,6,12 *"). For more information about this format, see Crontab (http://crontab.org).
	Recurrence *string `min:"1" type:"string"`

	// The name of the scaling action.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `min:"1" type:"string" required:"true"`

	// The time for the action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT
	// only and in quotes (for example, "2019-06-01T00:00:00Z").
	//
	// If you specify Recurrence and StartTime, Amazon EC2 Auto Scaling performs
	// the action at this time, and then performs the action based on the specified
	// recurrence.
	//
	// If you try to schedule the action in the past, Amazon EC2 Auto Scaling returns
	// an error message.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ScheduledUpdateGroupActionRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduledUpdateGroupActionRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ScheduledUpdateGroupActionRequest"}
	if s.Recurrence != nil && len(*s.Recurrence) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Recurrence", 1))
	}

	if s.ScheduledActionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScheduledActionName"))
	}
	if s.ScheduledActionName != nil && len(*s.ScheduledActionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ScheduledActionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an adjustment based on the difference between the value of the
// aggregated CloudWatch metric and the breach threshold that you've defined
// for the alarm. Used in combination with PutScalingPolicy.
//
// For the following examples, suppose that you have an alarm with a breach
// threshold of 50:
//
//    * To trigger the adjustment when the metric is greater than or equal to
//    50 and less than 60, specify a lower bound of 0 and an upper bound of
//    10.
//
//    * To trigger the adjustment when the metric is greater than 40 and less
//    than or equal to 50, specify a lower bound of -10 and an upper bound of
//    0.
//
// There are a few rules for the step adjustments for your step policy:
//
//    * The ranges of your step adjustments can't overlap or have a gap.
//
//    * At most, one step adjustment can have a null lower bound. If one step
//    adjustment has a negative lower bound, then there must be a step adjustment
//    with a null lower bound.
//
//    * At most, one step adjustment can have a null upper bound. If one step
//    adjustment has a positive upper bound, then there must be a step adjustment
//    with a null upper bound.
//
//    * The upper and lower bound can't be null in the same step adjustment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/StepAdjustment
type StepAdjustment struct {
	_ struct{} `type:"structure"`

	// The lower bound for the difference between the alarm threshold and the CloudWatch
	// metric. If the metric value is above the breach threshold, the lower bound
	// is inclusive (the metric must be greater than or equal to the threshold plus
	// the lower bound). Otherwise, it is exclusive (the metric must be greater
	// than the threshold plus the lower bound). A null value indicates negative
	// infinity.
	MetricIntervalLowerBound *float64 `type:"double"`

	// The upper bound for the difference between the alarm threshold and the CloudWatch
	// metric. If the metric value is above the breach threshold, the upper bound
	// is exclusive (the metric must be less than the threshold plus the upper bound).
	// Otherwise, it is inclusive (the metric must be less than or equal to the
	// threshold plus the upper bound). A null value indicates positive infinity.
	//
	// The upper bound must be greater than the lower bound.
	MetricIntervalUpperBound *float64 `type:"double"`

	// The amount by which to scale, based on the specified adjustment type. A positive
	// value adds to the current capacity while a negative number removes from the
	// current capacity.
	//
	// ScalingAdjustment is a required field
	ScalingAdjustment *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s StepAdjustment) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StepAdjustment) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StepAdjustment"}

	if s.ScalingAdjustment == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScalingAdjustment"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an automatic scaling process that has been suspended. For more
// information, see ProcessType.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SuspendedProcess
type SuspendedProcess struct {
	_ struct{} `type:"structure"`

	// The name of the suspended process.
	ProcessName *string `min:"1" type:"string"`

	// The reason that the process was suspended.
	SuspensionReason *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SuspendedProcess) String() string {
	return awsutil.Prettify(s)
}

// Describes a tag for an Auto Scaling group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Determines whether the tag is added to new instances as they are launched
	// in the group.
	PropagateAtLaunch *bool `type:"boolean"`

	// The name of the group.
	ResourceId *string `type:"string"`

	// The type of resource. The only supported value is auto-scaling-group.
	ResourceType *string `type:"string"`

	// The tag value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a tag for an Auto Scaling group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/TagDescription
type TagDescription struct {
	_ struct{} `type:"structure"`

	// The tag key.
	Key *string `min:"1" type:"string"`

	// Determines whether the tag is added to new instances as they are launched
	// in the group.
	PropagateAtLaunch *bool `type:"boolean"`

	// The name of the group.
	ResourceId *string `type:"string"`

	// The type of resource. The only supported value is auto-scaling-group.
	ResourceType *string `type:"string"`

	// The tag value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s TagDescription) String() string {
	return awsutil.Prettify(s)
}

// Represents a target tracking scaling policy configuration to use with Amazon
// EC2 Auto Scaling.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/TargetTrackingConfiguration
type TargetTrackingConfiguration struct {
	_ struct{} `type:"structure"`

	// A customized metric. You can specify either a predefined metric or a customized
	// metric.
	CustomizedMetricSpecification *CustomizedMetricSpecification `type:"structure"`

	// Indicates whether scaling in by the target tracking scaling policy is disabled.
	// If scaling in is disabled, the target tracking scaling policy doesn't remove
	// instances from the Auto Scaling group. Otherwise, the target tracking scaling
	// policy can remove instances from the Auto Scaling group. The default is disabled.
	DisableScaleIn *bool `type:"boolean"`

	// A predefined metric. You can specify either a predefined metric or a customized
	// metric.
	PredefinedMetricSpecification *PredefinedMetricSpecification `type:"structure"`

	// The target value for the metric.
	//
	// TargetValue is a required field
	TargetValue *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s TargetTrackingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetTrackingConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TargetTrackingConfiguration"}

	if s.TargetValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetValue"))
	}
	if s.CustomizedMetricSpecification != nil {
		if err := s.CustomizedMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("CustomizedMetricSpecification", err.(aws.ErrInvalidParams))
		}
	}
	if s.PredefinedMetricSpecification != nil {
		if err := s.PredefinedMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("PredefinedMetricSpecification", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
