// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorTerminationRequest
type DeleteVoiceConnectorTerminationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVoiceConnectorTerminationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceConnectorTerminationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteVoiceConnectorTerminationInput"}

	if s.VoiceConnectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VoiceConnectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteVoiceConnectorTerminationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.VoiceConnectorId != nil {
		v := *s.VoiceConnectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "voiceConnectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorTerminationOutput
type DeleteVoiceConnectorTerminationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVoiceConnectorTerminationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteVoiceConnectorTerminationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteVoiceConnectorTermination = "DeleteVoiceConnectorTermination"

// DeleteVoiceConnectorTerminationRequest returns a request value for making API operation for
// Amazon Chime.
//
// Deletes the termination settings for the specified Amazon Chime Voice Connector.
//
//    // Example sending a request using DeleteVoiceConnectorTerminationRequest.
//    req := client.DeleteVoiceConnectorTerminationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorTermination
func (c *Client) DeleteVoiceConnectorTerminationRequest(input *DeleteVoiceConnectorTerminationInput) DeleteVoiceConnectorTerminationRequest {
	op := &aws.Operation{
		Name:       opDeleteVoiceConnectorTermination,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination",
	}

	if input == nil {
		input = &DeleteVoiceConnectorTerminationInput{}
	}

	req := c.newRequest(op, input, &DeleteVoiceConnectorTerminationOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteVoiceConnectorTerminationRequest{Request: req, Input: input, Copy: c.DeleteVoiceConnectorTerminationRequest}
}

// DeleteVoiceConnectorTerminationRequest is the request type for the
// DeleteVoiceConnectorTermination API operation.
type DeleteVoiceConnectorTerminationRequest struct {
	*aws.Request
	Input *DeleteVoiceConnectorTerminationInput
	Copy  func(*DeleteVoiceConnectorTerminationInput) DeleteVoiceConnectorTerminationRequest
}

// Send marshals and sends the DeleteVoiceConnectorTermination API request.
func (r DeleteVoiceConnectorTerminationRequest) Send(ctx context.Context) (*DeleteVoiceConnectorTerminationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteVoiceConnectorTerminationResponse{
		DeleteVoiceConnectorTerminationOutput: r.Request.Data.(*DeleteVoiceConnectorTerminationOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteVoiceConnectorTerminationResponse is the response type for the
// DeleteVoiceConnectorTermination API operation.
type DeleteVoiceConnectorTerminationResponse struct {
	*DeleteVoiceConnectorTerminationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteVoiceConnectorTermination request.
func (r *DeleteVoiceConnectorTerminationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
