// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetGlobalSettingsInput
type GetGlobalSettingsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetGlobalSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetGlobalSettingsInput) MarshalFields(e protocol.FieldEncoder) error {

	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetGlobalSettingsResponse
type GetGlobalSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Business Calling settings.
	BusinessCalling *BusinessCallingSettings `type:"structure"`

	// The Amazon Chime Voice Connector settings.
	VoiceConnector *VoiceConnectorSettings `type:"structure"`
}

// String returns the string representation
func (s GetGlobalSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetGlobalSettingsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BusinessCalling != nil {
		v := s.BusinessCalling

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "BusinessCalling", v, metadata)
	}
	if s.VoiceConnector != nil {
		v := s.VoiceConnector

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VoiceConnector", v, metadata)
	}
	return nil
}

const opGetGlobalSettings = "GetGlobalSettings"

// GetGlobalSettingsRequest returns a request value for making API operation for
// Amazon Chime.
//
// Retrieves global settings for the administrator's AWS account, such as Amazon
// Chime Business Calling and Amazon Chime Voice Connector settings.
//
//    // Example sending a request using GetGlobalSettingsRequest.
//    req := client.GetGlobalSettingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetGlobalSettings
func (c *Client) GetGlobalSettingsRequest(input *GetGlobalSettingsInput) GetGlobalSettingsRequest {
	op := &aws.Operation{
		Name:       opGetGlobalSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/settings",
	}

	if input == nil {
		input = &GetGlobalSettingsInput{}
	}

	req := c.newRequest(op, input, &GetGlobalSettingsOutput{})
	return GetGlobalSettingsRequest{Request: req, Input: input, Copy: c.GetGlobalSettingsRequest}
}

// GetGlobalSettingsRequest is the request type for the
// GetGlobalSettings API operation.
type GetGlobalSettingsRequest struct {
	*aws.Request
	Input *GetGlobalSettingsInput
	Copy  func(*GetGlobalSettingsInput) GetGlobalSettingsRequest
}

// Send marshals and sends the GetGlobalSettings API request.
func (r GetGlobalSettingsRequest) Send(ctx context.Context) (*GetGlobalSettingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetGlobalSettingsResponse{
		GetGlobalSettingsOutput: r.Request.Data.(*GetGlobalSettingsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetGlobalSettingsResponse is the response type for the
// GetGlobalSettings API operation.
type GetGlobalSettingsResponse struct {
	*GetGlobalSettingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetGlobalSettings request.
func (r *GetGlobalSettingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
