// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudhsm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the inputs for the DeleteHapg action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteHapgRequest
type DeleteHapgInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the high-availability partition group to delete.
	//
	// HapgArn is a required field
	HapgArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHapgInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHapgInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteHapgInput"}

	if s.HapgArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("HapgArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of the DeleteHapg action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteHapgResponse
type DeleteHapgOutput struct {
	_ struct{} `type:"structure"`

	// The status of the action.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHapgOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteHapg = "DeleteHapg"

// DeleteHapgRequest returns a request value for making API operation for
// Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Deletes a high-availability partition group.
//
//    // Example sending a request using DeleteHapgRequest.
//    req := client.DeleteHapgRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteHapg
func (c *Client) DeleteHapgRequest(input *DeleteHapgInput) DeleteHapgRequest {
	op := &aws.Operation{
		Name:       opDeleteHapg,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHapgInput{}
	}

	req := c.newRequest(op, input, &DeleteHapgOutput{})
	return DeleteHapgRequest{Request: req, Input: input, Copy: c.DeleteHapgRequest}
}

// DeleteHapgRequest is the request type for the
// DeleteHapg API operation.
type DeleteHapgRequest struct {
	*aws.Request
	Input *DeleteHapgInput
	Copy  func(*DeleteHapgInput) DeleteHapgRequest
}

// Send marshals and sends the DeleteHapg API request.
func (r DeleteHapgRequest) Send(ctx context.Context) (*DeleteHapgResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteHapgResponse{
		DeleteHapgOutput: r.Request.Data.(*DeleteHapgOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteHapgResponse is the response type for the
// DeleteHapg API operation.
type DeleteHapgResponse struct {
	*DeleteHapgOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteHapg request.
func (r *DeleteHapgResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
