// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudhsm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the inputs for the DescribeHapg action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHapgRequest
type DescribeHapgInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the high-availability partition group to describe.
	//
	// HapgArn is a required field
	HapgArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeHapgInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeHapgInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeHapgInput"}

	if s.HapgArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("HapgArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of the DescribeHapg action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHapgResponse
type DescribeHapgOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the high-availability partition group.
	HapgArn *string `type:"string"`

	// The serial number of the high-availability partition group.
	HapgSerial *string `type:"string"`

	// Contains a list of ARNs that identify the HSMs.
	HsmsLastActionFailed []string `type:"list"`

	// Contains a list of ARNs that identify the HSMs.
	HsmsPendingDeletion []string `type:"list"`

	// Contains a list of ARNs that identify the HSMs.
	HsmsPendingRegistration []string `type:"list"`

	// The label for the high-availability partition group.
	Label *string `type:"string"`

	// The date and time the high-availability partition group was last modified.
	LastModifiedTimestamp *string `type:"string"`

	// The list of partition serial numbers that belong to the high-availability
	// partition group.
	PartitionSerialList []string `type:"list"`

	// The state of the high-availability partition group.
	State CloudHsmObjectState `type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeHapgOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeHapg = "DescribeHapg"

// DescribeHapgRequest returns a request value for making API operation for
// Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Retrieves information about a high-availability partition group.
//
//    // Example sending a request using DescribeHapgRequest.
//    req := client.DescribeHapgRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHapg
func (c *Client) DescribeHapgRequest(input *DescribeHapgInput) DescribeHapgRequest {
	op := &aws.Operation{
		Name:       opDescribeHapg,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHapgInput{}
	}

	req := c.newRequest(op, input, &DescribeHapgOutput{})
	return DescribeHapgRequest{Request: req, Input: input, Copy: c.DescribeHapgRequest}
}

// DescribeHapgRequest is the request type for the
// DescribeHapg API operation.
type DescribeHapgRequest struct {
	*aws.Request
	Input *DescribeHapgInput
	Copy  func(*DescribeHapgInput) DescribeHapgRequest
}

// Send marshals and sends the DescribeHapg API request.
func (r DescribeHapgRequest) Send(ctx context.Context) (*DescribeHapgResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeHapgResponse{
		DescribeHapgOutput: r.Request.Data.(*DescribeHapgOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeHapgResponse is the response type for the
// DescribeHapg API operation.
type DescribeHapgResponse struct {
	*DescribeHapgOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeHapg request.
func (r *DescribeHapgResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
