// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudhsm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the inputs for the DescribeHsm operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHsmRequest
type DescribeHsmInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the HSM. Either the HsmArn or the SerialNumber parameter must
	// be specified.
	HsmArn *string `type:"string"`

	// The serial number of the HSM. Either the HsmArn or the HsmSerialNumber parameter
	// must be specified.
	HsmSerialNumber *string `type:"string"`
}

// String returns the string representation
func (s DescribeHsmInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the output of the DescribeHsm operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHsmResponse
type DescribeHsmOutput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that the HSM is in.
	AvailabilityZone *string `type:"string"`

	// The identifier of the elastic network interface (ENI) attached to the HSM.
	EniId *string `type:"string"`

	// The IP address assigned to the HSM's ENI.
	EniIp *string `type:"string"`

	// The ARN of the HSM.
	HsmArn *string `type:"string"`

	// The HSM model type.
	HsmType *string `type:"string"`

	// The ARN of the IAM role assigned to the HSM.
	IamRoleArn *string `type:"string"`

	// The list of partitions on the HSM.
	Partitions []string `type:"list"`

	// The serial number of the HSM.
	SerialNumber *string `type:"string"`

	// The date and time that the server certificate was last updated.
	ServerCertLastUpdated *string `type:"string"`

	// The URI of the certificate server.
	ServerCertUri *string `type:"string"`

	// The HSM software version.
	SoftwareVersion *string `type:"string"`

	// The date and time that the SSH key was last updated.
	SshKeyLastUpdated *string `type:"string"`

	// The public SSH key.
	SshPublicKey *string `type:"string"`

	// The status of the HSM.
	Status HsmStatus `type:"string" enum:"true"`

	// Contains additional information about the status of the HSM.
	StatusDetails *string `type:"string"`

	// The identifier of the subnet that the HSM is in.
	SubnetId *string `type:"string"`

	// The subscription end date.
	SubscriptionEndDate *string `type:"string"`

	// The subscription start date.
	SubscriptionStartDate *string `type:"string"`

	// Specifies the type of subscription for the HSM.
	//
	//    * PRODUCTION - The HSM is being used in a production environment.
	//
	//    * TRIAL - The HSM is being used in a product trial.
	SubscriptionType SubscriptionType `type:"string" enum:"true"`

	// The name of the HSM vendor.
	VendorName *string `type:"string"`

	// The identifier of the VPC that the HSM is in.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DescribeHsmOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeHsm = "DescribeHsm"

// DescribeHsmRequest returns a request value for making API operation for
// Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Retrieves information about an HSM. You can identify the HSM by its ARN or
// its serial number.
//
//    // Example sending a request using DescribeHsmRequest.
//    req := client.DescribeHsmRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHsm
func (c *Client) DescribeHsmRequest(input *DescribeHsmInput) DescribeHsmRequest {
	op := &aws.Operation{
		Name:       opDescribeHsm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHsmInput{}
	}

	req := c.newRequest(op, input, &DescribeHsmOutput{})
	return DescribeHsmRequest{Request: req, Input: input, Copy: c.DescribeHsmRequest}
}

// DescribeHsmRequest is the request type for the
// DescribeHsm API operation.
type DescribeHsmRequest struct {
	*aws.Request
	Input *DescribeHsmInput
	Copy  func(*DescribeHsmInput) DescribeHsmRequest
}

// Send marshals and sends the DescribeHsm API request.
func (r DescribeHsmRequest) Send(ctx context.Context) (*DescribeHsmResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeHsmResponse{
		DescribeHsmOutput: r.Request.Data.(*DescribeHsmOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeHsmResponse is the response type for the
// DescribeHsm API operation.
type DescribeHsmResponse struct {
	*DescribeHsmOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeHsm request.
func (r *DescribeHsmResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
