// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudhsmv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/InitializeClusterRequest
type InitializeClusterInput struct {
	_ struct{} `type:"structure"`

	// The identifier (ID) of the cluster that you are claiming. To find the cluster
	// ID, use DescribeClusters.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The cluster certificate issued (signed) by your issuing certificate authority
	// (CA). The certificate must be in PEM format and can contain a maximum of
	// 5000 characters.
	//
	// SignedCert is a required field
	SignedCert *string `type:"string" required:"true"`

	// The issuing certificate of the issuing certificate authority (CA) that issued
	// (signed) the cluster certificate. This can be a root (self-signed) certificate
	// or a certificate chain that begins with the certificate that issued the cluster
	// certificate and ends with a root certificate. The certificate or certificate
	// chain must be in PEM format and can contain a maximum of 5000 characters.
	//
	// TrustAnchor is a required field
	TrustAnchor *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InitializeClusterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InitializeClusterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InitializeClusterInput"}

	if s.ClusterId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterId"))
	}

	if s.SignedCert == nil {
		invalidParams.Add(aws.NewErrParamRequired("SignedCert"))
	}

	if s.TrustAnchor == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrustAnchor"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/InitializeClusterResponse
type InitializeClusterOutput struct {
	_ struct{} `type:"structure"`

	// The cluster's state.
	State ClusterState `type:"string" enum:"true"`

	// A description of the cluster's state.
	StateMessage *string `type:"string"`
}

// String returns the string representation
func (s InitializeClusterOutput) String() string {
	return awsutil.Prettify(s)
}

const opInitializeCluster = "InitializeCluster"

// InitializeClusterRequest returns a request value for making API operation for
// AWS CloudHSM V2.
//
// Claims an AWS CloudHSM cluster by submitting the cluster certificate issued
// by your issuing certificate authority (CA) and the CA's root certificate.
// Before you can claim a cluster, you must sign the cluster's certificate signing
// request (CSR) with your issuing CA. To get the cluster's CSR, use DescribeClusters.
//
//    // Example sending a request using InitializeClusterRequest.
//    req := client.InitializeClusterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/InitializeCluster
func (c *Client) InitializeClusterRequest(input *InitializeClusterInput) InitializeClusterRequest {
	op := &aws.Operation{
		Name:       opInitializeCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &InitializeClusterInput{}
	}

	req := c.newRequest(op, input, &InitializeClusterOutput{})
	return InitializeClusterRequest{Request: req, Input: input, Copy: c.InitializeClusterRequest}
}

// InitializeClusterRequest is the request type for the
// InitializeCluster API operation.
type InitializeClusterRequest struct {
	*aws.Request
	Input *InitializeClusterInput
	Copy  func(*InitializeClusterInput) InitializeClusterRequest
}

// Send marshals and sends the InitializeCluster API request.
func (r InitializeClusterRequest) Send(ctx context.Context) (*InitializeClusterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &InitializeClusterResponse{
		InitializeClusterOutput: r.Request.Data.(*InitializeClusterOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// InitializeClusterResponse is the response type for the
// InitializeCluster API operation.
type InitializeClusterResponse struct {
	*InitializeClusterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// InitializeCluster request.
func (r *InitializeClusterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
