// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmsInput
type DescribeAlarmsInput struct {
	_ struct{} `type:"structure"`

	// The action name prefix.
	ActionPrefix *string `min:"1" type:"string"`

	// The alarm name prefix. If this parameter is specified, you cannot specify
	// AlarmNames.
	AlarmNamePrefix *string `min:"1" type:"string"`

	// The names of the alarms.
	AlarmNames []string `type:"list"`

	// The maximum number of alarm descriptions to retrieve.
	MaxRecords *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to indicate that there is more data
	// available.
	NextToken *string `type:"string"`

	// The state value to be used in matching alarms.
	StateValue StateValue `type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeAlarmsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlarmsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAlarmsInput"}
	if s.ActionPrefix != nil && len(*s.ActionPrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ActionPrefix", 1))
	}
	if s.AlarmNamePrefix != nil && len(*s.AlarmNamePrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AlarmNamePrefix", 1))
	}
	if s.MaxRecords != nil && *s.MaxRecords < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxRecords", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmsOutput
type DescribeAlarmsOutput struct {
	_ struct{} `type:"structure"`

	// The information for the specified alarms.
	MetricAlarms []MetricAlarm `type:"list"`

	// The token that marks the start of the next batch of returned results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAlarmsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAlarms = "DescribeAlarms"

// DescribeAlarmsRequest returns a request value for making API operation for
// Amazon CloudWatch.
//
// Retrieves the specified alarms. If no alarms are specified, all alarms are
// returned. Alarms can be retrieved by using only a prefix for the alarm name,
// the alarm state, or a prefix for any action.
//
//    // Example sending a request using DescribeAlarmsRequest.
//    req := client.DescribeAlarmsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarms
func (c *Client) DescribeAlarmsRequest(input *DescribeAlarmsInput) DescribeAlarmsRequest {
	op := &aws.Operation{
		Name:       opDescribeAlarms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAlarmsInput{}
	}

	req := c.newRequest(op, input, &DescribeAlarmsOutput{})
	return DescribeAlarmsRequest{Request: req, Input: input, Copy: c.DescribeAlarmsRequest}
}

// DescribeAlarmsRequest is the request type for the
// DescribeAlarms API operation.
type DescribeAlarmsRequest struct {
	*aws.Request
	Input *DescribeAlarmsInput
	Copy  func(*DescribeAlarmsInput) DescribeAlarmsRequest
}

// Send marshals and sends the DescribeAlarms API request.
func (r DescribeAlarmsRequest) Send(ctx context.Context) (*DescribeAlarmsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAlarmsResponse{
		DescribeAlarmsOutput: r.Request.Data.(*DescribeAlarmsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeAlarmsRequestPaginator returns a paginator for DescribeAlarms.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeAlarmsRequest(input)
//   p := cloudwatch.NewDescribeAlarmsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeAlarmsPaginator(req DescribeAlarmsRequest) DescribeAlarmsPaginator {
	return DescribeAlarmsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeAlarmsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeAlarmsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeAlarmsPaginator struct {
	aws.Pager
}

func (p *DescribeAlarmsPaginator) CurrentPage() *DescribeAlarmsOutput {
	return p.Pager.CurrentPage().(*DescribeAlarmsOutput)
}

// DescribeAlarmsResponse is the response type for the
// DescribeAlarms API operation.
type DescribeAlarmsResponse struct {
	*DescribeAlarmsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAlarms request.
func (r *DescribeAlarmsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
