// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/InvalidateProjectCacheInput
type InvalidateProjectCacheInput struct {
	_ struct{} `type:"structure"`

	// The name of the AWS CodeBuild build project that the cache is reset for.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InvalidateProjectCacheInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvalidateProjectCacheInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InvalidateProjectCacheInput"}

	if s.ProjectName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/InvalidateProjectCacheOutput
type InvalidateProjectCacheOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s InvalidateProjectCacheOutput) String() string {
	return awsutil.Prettify(s)
}

const opInvalidateProjectCache = "InvalidateProjectCache"

// InvalidateProjectCacheRequest returns a request value for making API operation for
// AWS CodeBuild.
//
// Resets the cache for a project.
//
//    // Example sending a request using InvalidateProjectCacheRequest.
//    req := client.InvalidateProjectCacheRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/InvalidateProjectCache
func (c *Client) InvalidateProjectCacheRequest(input *InvalidateProjectCacheInput) InvalidateProjectCacheRequest {
	op := &aws.Operation{
		Name:       opInvalidateProjectCache,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &InvalidateProjectCacheInput{}
	}

	req := c.newRequest(op, input, &InvalidateProjectCacheOutput{})
	return InvalidateProjectCacheRequest{Request: req, Input: input, Copy: c.InvalidateProjectCacheRequest}
}

// InvalidateProjectCacheRequest is the request type for the
// InvalidateProjectCache API operation.
type InvalidateProjectCacheRequest struct {
	*aws.Request
	Input *InvalidateProjectCacheInput
	Copy  func(*InvalidateProjectCacheInput) InvalidateProjectCacheRequest
}

// Send marshals and sends the InvalidateProjectCache API request.
func (r InvalidateProjectCacheRequest) Send(ctx context.Context) (*InvalidateProjectCacheResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &InvalidateProjectCacheResponse{
		InvalidateProjectCacheOutput: r.Request.Data.(*InvalidateProjectCacheOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// InvalidateProjectCacheResponse is the response type for the
// InvalidateProjectCache API operation.
type InvalidateProjectCacheResponse struct {
	*InvalidateProjectCacheOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// InvalidateProjectCache request.
func (r *InvalidateProjectCacheResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
