// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codedeploy

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Represents the input of the register on-premises instance operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterOnPremisesInstanceInput
type RegisterOnPremisesInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM session to associate with the on-premises instance.
	IamSessionArn *string `locationName:"iamSessionArn" type:"string"`

	// The ARN of the IAM user to associate with the on-premises instance.
	IamUserArn *string `locationName:"iamUserArn" type:"string"`

	// The name of the on-premises instance to register.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterOnPremisesInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterOnPremisesInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegisterOnPremisesInstanceInput"}

	if s.InstanceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterOnPremisesInstanceOutput
type RegisterOnPremisesInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterOnPremisesInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opRegisterOnPremisesInstance = "RegisterOnPremisesInstance"

// RegisterOnPremisesInstanceRequest returns a request value for making API operation for
// AWS CodeDeploy.
//
// Registers an on-premises instance.
//
// Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the
// request. You cannot use both.
//
//    // Example sending a request using RegisterOnPremisesInstanceRequest.
//    req := client.RegisterOnPremisesInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterOnPremisesInstance
func (c *Client) RegisterOnPremisesInstanceRequest(input *RegisterOnPremisesInstanceInput) RegisterOnPremisesInstanceRequest {
	op := &aws.Operation{
		Name:       opRegisterOnPremisesInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterOnPremisesInstanceInput{}
	}

	req := c.newRequest(op, input, &RegisterOnPremisesInstanceOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return RegisterOnPremisesInstanceRequest{Request: req, Input: input, Copy: c.RegisterOnPremisesInstanceRequest}
}

// RegisterOnPremisesInstanceRequest is the request type for the
// RegisterOnPremisesInstance API operation.
type RegisterOnPremisesInstanceRequest struct {
	*aws.Request
	Input *RegisterOnPremisesInstanceInput
	Copy  func(*RegisterOnPremisesInstanceInput) RegisterOnPremisesInstanceRequest
}

// Send marshals and sends the RegisterOnPremisesInstance API request.
func (r RegisterOnPremisesInstanceRequest) Send(ctx context.Context) (*RegisterOnPremisesInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterOnPremisesInstanceResponse{
		RegisterOnPremisesInstanceOutput: r.Request.Data.(*RegisterOnPremisesInstanceOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterOnPremisesInstanceResponse is the response type for the
// RegisterOnPremisesInstance API operation.
type RegisterOnPremisesInstanceResponse struct {
	*RegisterOnPremisesInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterOnPremisesInstance request.
func (r *RegisterOnPremisesInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
