// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitosync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request for a list of the configured Cognito Events
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/GetCognitoEventsRequest
type GetCognitoEventsInput struct {
	_ struct{} `type:"structure"`

	// The Cognito Identity Pool ID for the request
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCognitoEventsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCognitoEventsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCognitoEventsInput"}

	if s.IdentityPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCognitoEventsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.IdentityPoolId != nil {
		v := *s.IdentityPoolId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "IdentityPoolId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The response from the GetCognitoEvents request
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/GetCognitoEventsResponse
type GetCognitoEventsOutput struct {
	_ struct{} `type:"structure"`

	// The Cognito Events returned from the GetCognitoEvents request
	Events map[string]string `type:"map"`
}

// String returns the string representation
func (s GetCognitoEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCognitoEventsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Events) > 0 {
		v := s.Events

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Events", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

const opGetCognitoEvents = "GetCognitoEvents"

// GetCognitoEventsRequest returns a request value for making API operation for
// Amazon Cognito Sync.
//
// Gets the events and the corresponding Lambda functions associated with an
// identity pool.
//
// This API can only be called with developer credentials. You cannot call this
// API with the temporary user credentials provided by Cognito Identity.
//
//    // Example sending a request using GetCognitoEventsRequest.
//    req := client.GetCognitoEventsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/GetCognitoEvents
func (c *Client) GetCognitoEventsRequest(input *GetCognitoEventsInput) GetCognitoEventsRequest {
	op := &aws.Operation{
		Name:       opGetCognitoEvents,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools/{IdentityPoolId}/events",
	}

	if input == nil {
		input = &GetCognitoEventsInput{}
	}

	req := c.newRequest(op, input, &GetCognitoEventsOutput{})
	return GetCognitoEventsRequest{Request: req, Input: input, Copy: c.GetCognitoEventsRequest}
}

// GetCognitoEventsRequest is the request type for the
// GetCognitoEvents API operation.
type GetCognitoEventsRequest struct {
	*aws.Request
	Input *GetCognitoEventsInput
	Copy  func(*GetCognitoEventsInput) GetCognitoEventsRequest
}

// Send marshals and sends the GetCognitoEvents API request.
func (r GetCognitoEventsRequest) Send(ctx context.Context) (*GetCognitoEventsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCognitoEventsResponse{
		GetCognitoEventsOutput: r.Request.Data.(*GetCognitoEventsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCognitoEventsResponse is the response type for the
// GetCognitoEvents API operation.
type GetCognitoEventsResponse struct {
	*GetCognitoEventsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCognitoEvents request.
func (r *GetCognitoEventsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
