// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTopicsDetectionJobRequest
type DescribeTopicsDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier assigned by the user to the detection job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTopicsDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTopicsDetectionJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTopicsDetectionJobInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTopicsDetectionJobResponse
type DescribeTopicsDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The list of properties for the requested job.
	TopicsDetectionJobProperties *TopicsDetectionJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeTopicsDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTopicsDetectionJob = "DescribeTopicsDetectionJob"

// DescribeTopicsDetectionJobRequest returns a request value for making API operation for
// Amazon Comprehend.
//
// Gets the properties associated with a topic detection job. Use this operation
// to get the status of a detection job.
//
//    // Example sending a request using DescribeTopicsDetectionJobRequest.
//    req := client.DescribeTopicsDetectionJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTopicsDetectionJob
func (c *Client) DescribeTopicsDetectionJobRequest(input *DescribeTopicsDetectionJobInput) DescribeTopicsDetectionJobRequest {
	op := &aws.Operation{
		Name:       opDescribeTopicsDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTopicsDetectionJobInput{}
	}

	req := c.newRequest(op, input, &DescribeTopicsDetectionJobOutput{})
	return DescribeTopicsDetectionJobRequest{Request: req, Input: input, Copy: c.DescribeTopicsDetectionJobRequest}
}

// DescribeTopicsDetectionJobRequest is the request type for the
// DescribeTopicsDetectionJob API operation.
type DescribeTopicsDetectionJobRequest struct {
	*aws.Request
	Input *DescribeTopicsDetectionJobInput
	Copy  func(*DescribeTopicsDetectionJobInput) DescribeTopicsDetectionJobRequest
}

// Send marshals and sends the DescribeTopicsDetectionJob API request.
func (r DescribeTopicsDetectionJobRequest) Send(ctx context.Context) (*DescribeTopicsDetectionJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTopicsDetectionJobResponse{
		DescribeTopicsDetectionJobOutput: r.Request.Data.(*DescribeTopicsDetectionJobOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeTopicsDetectionJobResponse is the response type for the
// DescribeTopicsDetectionJob API operation.
type DescribeTopicsDetectionJobResponse struct {
	*DescribeTopicsDetectionJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTopicsDetectionJob request.
func (r *DescribeTopicsDetectionJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
