// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobsRequest
type ListKeyPhrasesDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *KeyPhrasesDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListKeyPhrasesDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKeyPhrasesDetectionJobsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListKeyPhrasesDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobsResponse
type ListKeyPhrasesDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job that is returned.
	KeyPhrasesDetectionJobPropertiesList []KeyPhrasesDetectionJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListKeyPhrasesDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListKeyPhrasesDetectionJobs = "ListKeyPhrasesDetectionJobs"

// ListKeyPhrasesDetectionJobsRequest returns a request value for making API operation for
// Amazon Comprehend.
//
// Get a list of key phrase detection jobs that you have submitted.
//
//    // Example sending a request using ListKeyPhrasesDetectionJobsRequest.
//    req := client.ListKeyPhrasesDetectionJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs
func (c *Client) ListKeyPhrasesDetectionJobsRequest(input *ListKeyPhrasesDetectionJobsInput) ListKeyPhrasesDetectionJobsRequest {
	op := &aws.Operation{
		Name:       opListKeyPhrasesDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKeyPhrasesDetectionJobsInput{}
	}

	req := c.newRequest(op, input, &ListKeyPhrasesDetectionJobsOutput{})
	return ListKeyPhrasesDetectionJobsRequest{Request: req, Input: input, Copy: c.ListKeyPhrasesDetectionJobsRequest}
}

// ListKeyPhrasesDetectionJobsRequest is the request type for the
// ListKeyPhrasesDetectionJobs API operation.
type ListKeyPhrasesDetectionJobsRequest struct {
	*aws.Request
	Input *ListKeyPhrasesDetectionJobsInput
	Copy  func(*ListKeyPhrasesDetectionJobsInput) ListKeyPhrasesDetectionJobsRequest
}

// Send marshals and sends the ListKeyPhrasesDetectionJobs API request.
func (r ListKeyPhrasesDetectionJobsRequest) Send(ctx context.Context) (*ListKeyPhrasesDetectionJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListKeyPhrasesDetectionJobsResponse{
		ListKeyPhrasesDetectionJobsOutput: r.Request.Data.(*ListKeyPhrasesDetectionJobsOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListKeyPhrasesDetectionJobsRequestPaginator returns a paginator for ListKeyPhrasesDetectionJobs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListKeyPhrasesDetectionJobsRequest(input)
//   p := comprehend.NewListKeyPhrasesDetectionJobsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListKeyPhrasesDetectionJobsPaginator(req ListKeyPhrasesDetectionJobsRequest) ListKeyPhrasesDetectionJobsPaginator {
	return ListKeyPhrasesDetectionJobsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListKeyPhrasesDetectionJobsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListKeyPhrasesDetectionJobsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListKeyPhrasesDetectionJobsPaginator struct {
	aws.Pager
}

func (p *ListKeyPhrasesDetectionJobsPaginator) CurrentPage() *ListKeyPhrasesDetectionJobsOutput {
	return p.Pager.CurrentPage().(*ListKeyPhrasesDetectionJobsOutput)
}

// ListKeyPhrasesDetectionJobsResponse is the response type for the
// ListKeyPhrasesDetectionJobs API operation.
type ListKeyPhrasesDetectionJobsResponse struct {
	*ListKeyPhrasesDetectionJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListKeyPhrasesDetectionJobs request.
func (r *ListKeyPhrasesDetectionJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
