// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResourceRequest
type GetComplianceDetailsByResourceInput struct {
	_ struct{} `type:"structure"`

	// Filters the results by compliance.
	//
	// The allowed values are COMPLIANT, NON_COMPLIANT, and NOT_APPLICABLE.
	ComplianceTypes []ComplianceType `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The ID of the AWS resource for which you want compliance information.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The type of the AWS resource for which you want compliance information.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetComplianceDetailsByResourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComplianceDetailsByResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetComplianceDetailsByResourceInput"}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceId", 1))
	}

	if s.ResourceType == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResourceResponse
type GetComplianceDetailsByResourceOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the specified AWS resource complies each AWS Config rule.
	EvaluationResults []EvaluationResult `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetComplianceDetailsByResourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetComplianceDetailsByResource = "GetComplianceDetailsByResource"

// GetComplianceDetailsByResourceRequest returns a request value for making API operation for
// AWS Config.
//
// Returns the evaluation results for the specified AWS resource. The results
// indicate which AWS Config rules were used to evaluate the resource, when
// each rule was last used, and whether the resource complies with each rule.
//
//    // Example sending a request using GetComplianceDetailsByResourceRequest.
//    req := client.GetComplianceDetailsByResourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource
func (c *Client) GetComplianceDetailsByResourceRequest(input *GetComplianceDetailsByResourceInput) GetComplianceDetailsByResourceRequest {
	op := &aws.Operation{
		Name:       opGetComplianceDetailsByResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetComplianceDetailsByResourceInput{}
	}

	req := c.newRequest(op, input, &GetComplianceDetailsByResourceOutput{})
	return GetComplianceDetailsByResourceRequest{Request: req, Input: input, Copy: c.GetComplianceDetailsByResourceRequest}
}

// GetComplianceDetailsByResourceRequest is the request type for the
// GetComplianceDetailsByResource API operation.
type GetComplianceDetailsByResourceRequest struct {
	*aws.Request
	Input *GetComplianceDetailsByResourceInput
	Copy  func(*GetComplianceDetailsByResourceInput) GetComplianceDetailsByResourceRequest
}

// Send marshals and sends the GetComplianceDetailsByResource API request.
func (r GetComplianceDetailsByResourceRequest) Send(ctx context.Context) (*GetComplianceDetailsByResourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetComplianceDetailsByResourceResponse{
		GetComplianceDetailsByResourceOutput: r.Request.Data.(*GetComplianceDetailsByResourceOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetComplianceDetailsByResourceResponse is the response type for the
// GetComplianceDetailsByResource API operation.
type GetComplianceDetailsByResourceResponse struct {
	*GetComplianceDetailsByResourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetComplianceDetailsByResource request.
func (r *GetComplianceDetailsByResourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
